proc(data)=istagraphic(datain)   
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istagraphic istastatistic istatransformation 
; -----------------------------------------------------------------------
; Macro        istagraphic
; -----------------------------------------------------------------------
; Description  starts menu graphic in ISTA 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  selhead="ISTA Graphic"
  selitem="Barchart"|"Dotplot"|"Boxplot"|"Histogram"|"Andrews curves"
  selitem=selitem|"Parallel coordinate plot"|"Scatterplot"
  do
    sel=selectitem(selhead,selitem)
    if (sel[1])
      barchart(data)
    endif
    if (sel[2])
      dotplot(data)
    endif
    if (sel[3])
      boxplot(data)
    endif
    if (sel[4])
      histogram(data)
    endif
    if (sel[5])
      andrewscurv(data)
    endif
    if (sel[6])
      parallel(data)
    endif
    if (sel[7])
      scatter(data)
    endif
  until(sum(sel).=0)
endp