proc(data)=istastatistic(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istagraphic istastatistic istatransformation 
; -----------------------------------------------------------------------
; Macro        istastatistic
; -----------------------------------------------------------------------
; Description  starts menu statistic in ISTA 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------  
  data=datain
  selhead="ISTA Statistic"
  selitem="Descriptive"|"Correlations"|"Frequencies"|"Linear regression"
  selitem=selitem|"Neural networks"
  do
    sel=selectitem(selhead,selitem)
    if (sel[1])
      selhead1="Descriptiv"
      selitem1="short descriptive"|"long descriptive"
      do
        sel1=selectitem(selhead1,selitem1)
        if (sel1[1])
          data=descriptiveshort(data)
        endif
        if (sel1[2])
           data=descriptivelong(data)
        endif
      until(sum(sel1).=0)
    endif
    if (sel[2])
      data=relations(data)
    endif
    if (sel[3])
      data=frequencies(data)
    endif
    if (sel[4])
      {data,datahx,y,Vin}=regressionselection(data)
    endif
    if (sel[5])
      textY=" (dependent) "
      datah=paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
      colh=data.colname
      do
        sel2=choosevariable2(data,textY)  
      until(sum(sel2).=0||(sum(sel2).=1))
      if(sum(sel2)>0)
        textX=" (independent) "
        sel1=choosevariableX(data,textX,sel2)  
        if(sum(sel1)>0)
          datahx=paf(datah',sel1)'
          colhx=paf(colh,sel1)
          coltx=paf(data.coltype,sel1)
          x=datahx
          ;matrix for X variables
          y=paf(datah',sel2)'
          colhy=paf(colh,sel2)
          ;selection Y 
        endif
      endif
      if(exist(x)&&exist(y))
        do
          selheadt="ISTA Neural nets"
          selitemt="single network"|"Committee of networks"
          selt=selectitem(selheadt,selitemt)
          if(selt[1])
            data=neuronal(data,x,y)    
          endif
          if(selt[2])
            data=committee(data,x,y)  
          endif
        until(sum(selt).=0)
      endif
    endif 
  until(sum(sel).=0)
endp