proc(A,V,ctrl) = itera(A0,FI,b,N,eps,itmax,expl)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerz
; -----------------------------------------------------------------
;   Macro        itera
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;
;                - if possible - solves for 
;                Lambda~N(0,FI) (FI:: Fisher-Info)
;
;                A^{-1} =E [ Lambda Lambda' w_b ]  (1)
;
;                w_b=min(1,b/|A Lambda|)
;
;                using a fixed-point-algorithm
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          {A,V,ctrl}=itera(A0,FI,b,N,eps,itmax,expl)
;   Input
;     Parameter   A0  
;     Definition     p x p; starting value for A; if 0 is entered I^{-1} is taken
;                                 if p>1 and dim(A0)==1 I^{-1}*A0 is taken
;     Parameter   FI    
;     Definition     p x p; Fisher-Information
;     Parameter   b    
;     Definition     numeric; clipping height
;     Parameter    N
;     Definition      integer; MC-sample size / integration grid-points
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter    itmax
;     Definition      integer; maximal number of iterations
;     Parameter    expl
;     Definition      numeric; threshold for the changes in abs. value of A: 
;                        beyond this value convergence is uncertain  ~ 4
; Output                                                           
;     Parameter   A
;     Definition     p x p;  Lagrange-Multiplyer solving (1)
;     Parameter   V
;     Definition     p x p;  corresponding Covariance
;     Parameter   ctrl
;     Definition     integer; tells if convergence "happened"
; -----------------------------------------------------------------
; Notes
;   Not to be used outside of rICfil!
;
;   Is called by ICerz.
;
;   Calles [within kalman.lib]  numint2 stointp.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
p=rows(FI)

if ((rows(FI)>1)&&(dim(A0)==1))
   A=ginv(FI)*abs(A0)
endif


if (A0==0)
   A=ginv(FI)
else
   A=A0
endif

As=svd(A)
FIs=svd(FI)


aI=(As.l).*(FIs.l)
aIh=(As.l).*sqrt(FIs.l)
i=0
del1=eps+1
del2=expl-1
del3=1
norm=max(abs(aI))

while((del1>eps)&&(i<itmax)&&(del2<expl)&&(del3<expl^2))
   altaI=aI
   norm0=norm
   
   if (p==2)
       erg=numint2(aIh,b,N)
   endif
   if (p>2)
       erg=stointp(aIh,b,N)
   endif
   
   h=(erg.r>0).*(erg.r)+(erg.r==0) 
   aI=1/h.*(erg.r>0)
   h2=(FIs.l>0).*(sqrt(FIs.l))+(FIs.l==0) 
   aIh=aI/h2.*(FIs.l>0)
   i=i+1
   norm=max(abs(aI))
   del1=sum(abs(aI-altaI))
   del2=norm/norm0
   del3=del3*del2
endo

ctrl=((del3>expl^2)||(del2>expl))+2*(i>itmax)
h2=(FIs.l>0).*(FIs.l)+(FIs.l==0) 
aI=aI/h2.*(FIs.l>0)
vI=aIh^2.*(erg.s)

A=FIs.u*(aI.*FIs.v')
V=FIs.u*(vI.*FIs.v')

endp
