proc(xy, mh)=looreg(x, y, h)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      sker
; -----------------------------------------------------------------
;   Macro        looreg
; -----------------------------------------------------------------
;   Description  computes the Nadaraya-Watson leave-one-out 
;		 estimator without binning using the quartic kernel.
;		 Prior to estimation, looreg sorts the data. The 
;                sorted data, along with the sorted leave-one-out 
;		 regression estimates, are returned as an output. 
; -----------------------------------------------------------------
;   Usage         {xs, mh} = looreg (x, y, h)
;   Input
;     Parameter  x  
;     Definition n x p matrix, observations of explanatory variables
;     Parameter  y  
;     Definition n x 1 matrix, observations of the dependent variable
;     Parameter  h 
;     Definition n x p  matrix. or 1 x p  vector,
;                or n x 1  vector, or scalar depending on whether 
;                one wants to use global or local bandwidth and if 
;                one uses the same bandwidth in all directions or 
;                one for each direction.      
;   Output
;     Parameter  xy  
;     Definition n x (p+1) matrix, the sorted data, the first p columns
;		 contain the sorted observations of the explanatory 
;		 while the last column contains the sorted observations 
;		 of the dependent variable
;     Parameter  mh 
;     Definition n x 1 matrix, the sorted leave-one-out regression estimates
; -----------------------------------------------------------------
;   Example   library("smoother")
;             z=read("nicfoo")
;             x=z[,1]
;             y=z[,2]
;             h=0.5
;             {xy, mh} = looreg (x, y, h)          
;             dd=createdisplay(1,1)
;             show(dd,1,1,xy,xy[,1]~mh )
; -----------------------------------------------------------------
;   Result    Computes the leave-one-out Nadaraya-Watson estimator 
;	            of the regression of y on x for the nicfoo data. 
; -----------------------------------------------------------------
;   Author    Axel Werwatz, 220197   
; -----------------------------------------------------------------
	if (cols(h)==1)
        h =  h*matrix(1,cols(x))
	endif
	xy=sort(x~y)
	n=rows(xy)
	ys=matrix(rows(xy))~xy[,cols(xy)]
	xs=xy[,1:(cols(xy)-1)]
	regh = sker(xs,h,"qua",ys)
	loodenh = regh[,1] - (n*prod(h'))^(-1).*0.9375     
	loonumh = regh[,2] - (n*prod(h'))^(-1).*0.9375.*ys[,2]  
	loodenh = loodenh + (loodenh .= 0)
	mh = loonumh./loodenh
endp
