proc(Gini,Herfindahl)=lorenz(y)		
; ---------------------------------------------------------------------
; Library     stats
; ---------------------------------------------------------------------
; See_also    plotlorenz
; ----------------------------------------------------------------------------
; Macro       lorenz
; ---------------------------------------------------------------------
; Keywords    Gini coefficient, Herfindahl coefficient,
; Keywords    Lorenz curve, concentration
; ----------------------------------------------------------------------------
; Reference   Kotz/Johnson (1985): Encyclopedia of Statistical
;             Sciences, vol 5, p.156f.
; ---------------------------------------------------------------------
; Description calculates the measures of concentration of Gini 
;             and Herfindahl
; ---------------------------------------------------------------------
; Usage       lorenz(y)
;   Input       
;     Parameter     y (must be positive)
;       Definition  n x 1 vector of original data or
;                   n x 2 matrix of classified data:
;                     first column = class means
;                     second column = frequencies.
;   Output      
;     Parameter     Gini
;       Definition    number in [0,1], Gini coefficient  
;     Parameter     Herfindahl
;       Definition    number in [0,1], Herfindahl measure of concentration
; ---------------------------------------------------------------------
; Notes       library("plot") is needed
; ---------------------------------------------------------------------
; Example     library("stats")
;             x = normal(200)
;             x = abs(x)
;             lorenz(x)
;             y = 1:5 ~ #(2,6,8,5,2)
;             lorenz(y)
; ---------------------------------------------------------------------
; Result      returns Gini and Herfindahl coefficients
; ---------------------------------------------------------------------
; Author      Albrecht Kaufmann, 990725; Knut Bartels, 990921
; ---------------------------------------------------------------------
   error(cols(y)>2,"input can have maxixmal 2 columns")
   n = rows(y)
   if(cols(y)==1)
      ;y[,1]= original data or class means
    y = y ~ matrix(n)     ; y[,2]= frequencies 
   endif
   error(sum(sum(y.>=0),2)!=2*n,"input must be nonnegative")
   y = paf(y,(y[,2]<>0))
   x=sort(y,1)	  
   n=rows(x)	    
   x[,1]=x[,1].*x[,2]
   X=sum(x[,1])	   
   H=sum(x[,2])	  
   rms=x[,1]/X      ; rms= relative shares of sum of observations
   p=x[,2]/H	    ; p=relative frequencies
   RMS=cumsum(rms)
   F=cumsum(p)
; 
;   L=setmask((0|F)~(0|RMS),"line","red","thick") ;Lorenz-curve
;   diag=setmask(#(0,1)~#(0,1),"line")
;   frame=setmask(#(0,1,1,0,0)~#(0,0,1,1,0),"line","thin")
;   Lorenzcurve=createdisplay(1,1)
;   show(Lorenzcurve,1,1,L,diag,frame)
;   setgopt(Lorenzcurve,1,1,"title","Lorenz-curve")
;
   hv=matrix(n)-0.5*p
   i=2
   while (i<=n)
      hv[i]=hv[i]-F[i-1]
      i=i+1
   endo
   Gini=1-2*rms'*hv		; Gini coeffizient
   Herfindahl=sum(rms^2)	; Herfindahl measure of concentration
endp

