proc(hrot)=lpderrot(x,q,p)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      lpderest
; -----------------------------------------------------------------
;   Keywords     kernel smoothing, kernel regression estimation, 
;                bandwidth selection, local polynomial regression
; -----------------------------------------------------------------
;   Macro        lpderrot
; -----------------------------------------------------------------
;   Description  determines a rule-of-thumb bandwidth for univariate 
;                local polynomial derivatives estimation using the
;                Quartic kernel.
; -----------------------------------------------------------------
;   Reference    Fan and Gijbels (1995): Local Polynomial Fitting
; -----------------------------------------------------------------
;   Usage        hrot = lpderrot(x {,q {,p}} {,K})
;   Input
;     Parameter  x  
;     Definition   n x 2 vector, the data.  
;     Parameter  q
;     Definition   integer <=4, order of derivative. If not 
;                  given, q=1 (first derivative) is used. 
;     Parameter  p
;     Definition   integer, order of polynomial. Must be q+1
;                  or q+3. If not given, p=q+1 is used. 
;   Output
;     Parameter  hrot  
;     Definition   scalar, rule-of-thumb bandwidth.
; -----------------------------------------------------------------
;   Example   library("smoother")
;             x=read("nicfoo")
;             hrot=lpderrot(x)
;             hrot
; -----------------------------------------------------------------
;   Result    Contents of hrot
;             [1,]  0.53133 
;-----------------------------------------------------------------
;   Author    Marlene Mueller, 990413
; ----------------------------------------------------------------- 
  if (exist(q)==0)
    q=1
  endif
  error(q>4, "lpderrot: q > 4 not implemented")
;  
  if (exist(p)==1)
    error((p!=(q+1))&&(p!=(q+3)),"lpderrot: please use p=q+1 or p=q+3")
  endif
  if (exist(p)==0)
    p=q+1
  endif
;
  if (q==0)
    hrot=lpregrot(x,p)
  else
    n=rows(x)
    c = (2.5859|3.20799|3.86043|4.52975)~(4.23394|4.87416|5.53588|6.21104)
    c=c[,1]~(0|0|0|0)~c[,2]
    xx=matrix(n,1)
    j=1
    while (j.<=p+3)
      xx=xx~x[,1]^j
      j=j+1
    endo
;
    al=gls(xx,x[,2])                           ; polyn. fit of order p+3
    rotsig=(x[,2]-xx*al)'*(x[,2]-xx*al)./n     ; variance estimate
    dx=max(x[,1])-min(x[,1])
    il=min(x[,1])+0.15*dx
    iu=min(x[,1])+0.85*dx
    intu=lprotint(iu,al,p)
    intl=lprotint(il,al,p)
    introt=intu-intl
    hrot=((iu-il)*rotsig)/(n*introt)
    hrot=c[q,p-q]*hrot^(1/(2*p+3))             ; rule-of-thumb bandwidth
  endif
endp   

