proc(v)=mat2vec(d)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    vec2mat distance lpdist agglom corrdist 
; -----------------------------------------------------------------------
; Macro       mat2vec
; -----------------------------------------------------------------------
; Description stores the upper triangle of a symmetric matrix
;             into a vector regarding the sequence described
;             in agglom
; -----------------------------------------------------------------------
; Usage        v = mat2vec(d) 
; Input
;   Parameter  d 
;   Definition n x n  matrix (for example a correlation matrix or
;                             a distance matrix)
; Output
;   Parameter  v
;   Definition n(n-1)/2 x 1 matrix containing the values of the upper 
;                           triangle of d (for instance, the vector v
;                           can be used as the input parameter of the
;                           function "agglom" if d contains distances)
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate a symmetric matrix
;             d = #(0, 2, 3, 7)~#(2, 0, 1, 8)~#(3, 1, 0, 5)~#(7, 8, 5, 0)
;             ; extract upper triangle
;             mat2vec(d)
; -----------------------------------------------------------------------
; Result      Content of object v
;
;             [1,]        2 
;             [2,]        3 
;             [3,]        7 
;             [4,]        1 
;             [5,]        8 
;             [6,]        5 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  j=rows(d)
  v=matrix((j*j-j)/2)
  i=1
  do
    k=0
    i=i+1
    do
      k=k+1
      m=j*(k-1)-k*(k-1)/2+i-k
      v[m,1]=d[k,i]
    until(k.=i-1)
  until(i.=j)      
endp      
