proc(data)=missingsmethod(datain,sel)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata missings
; -----------------------------------------------------------------------
; Macro        missingsmethod
; -----------------------------------------------------------------------
; Description  offers three possibilities to the user to handle the missing
;              values in the data set. It is possible to exclude the 
;              variable, the case or to replace the missing with a specified
;              value.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
data=datain
datah=data.x
selhead="Select method "+"("+data.colname[sel]+")"
selitem="delete case (for all variables)"|"delete variable"|"replace"
    sel1=selectitem(selhead,selitem,"single")
    if (sel1[1])
    x=data.x[,sel]
      isnan=isNaN(x)
      if(sum(isnan)<>0)               ;missings:exclude cases
        selk=paf(1:rows(data.rowcase),(isnan==1)) 
        data.rowmissing[selk]=0
      endif
    endif
    if (sel1[2])
      x=data.x[,sel]
      isnan=isNaN(x)
      if(sum(isnan)<>0)               ;missings:exclude variable
        data.colmissing[sel]=0       
      endif
    endif
    if (sel1[3])
      x=data.x[,sel]
      isnan=isNaN(x)
      if(sum(isnan)<>0)              ;missings:replace NaN with value
        selk=paf(1:rows(x),(isnan==1)) 
        xm=mean(paf(x,(1-isNaN(x)))) ;mean without NaNs as default
        vs = xm    
        vstr= "Select value "+"("+data.colname[sel]+")" 
        v=readvalue(vstr,vs)
        x[selk]=v
        datah[,sel]=x
       endif  
    endif
data.x=datah
endp