proc(y) = mseq (x, n, d)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      : aseq
; -----------------------------------------------------------------
;  Keywords      sequence, multiplicative sequence
; -----------------------------------------------------------------
;   Macro        mseq
; -----------------------------------------------------------------
;   Description  Computes a multiplicative sequence.
; -----------------------------------------------------------------
;   Usage        y = mseq (x, n, d)
;   Input
;     Parameter  x  
;     Definition start value
;     Parameter  n
;     Definition length
;     Parameter  d
;     Definition step factor
;   Output
;     Parameter  y
;     Definition vector
; -----------------------------------------------------------------
;   Example   library("xplore")
;             mseq (2, 4, 0.1)
; -----------------------------------------------------------------
;   Result
;	      Contents of y
;             [1,]        2 
;             [2,]      0.2 
;             [3,]     0.02 
;             [4,]    0.002 
; -----------------------------------------------------------------
;   Author    TTK, 960207, Sigbert Klinke, Marlene Mueller, 980406
; -----------------------------------------------------------------
 y = x * d^(0:(n-1))
endp
