proc(ts)=nnrinfo(net)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     nnrnet ann
; -----------------------------------------------------------------------
; Macro        nnrinfo
; -----------------------------------------------------------------------
; Description  shows information about the net in the output window.
; -----------------------------------------------------------------------
; Usage        nnrinfo(net)
; Input
;   Parameter  net
;   Definition composed object from nnrnet
; Output
; -----------------------------------------------------------------------
; Example     x = read("kredit1")
;             t = read("tkredit")
;             y = x[,1]
;             x = x[,2:21]
;             x = (x-min(x))./(max(x)-min(x))
;             net = nnrnet (x, y, matrix(rows(x)), 10)
;             nnrinfo (net)
; -----------------------------------------------------------------------
; Result      runs a neural network with 10 hidden units for the kredit 
;             data of Fahrmeier and Hammerle and computes the predicted
;             values. At last it shows the results.
; -----------------------------------------------------------------------
; Reference   Venables and Ripley (1994). Modern Applied Statistics with
;             S-Plus. p. 261-266
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 970604
; -----------------------------------------------------------------------
  tconn = net.nconn[2:rows(net.nconn)] - net.nconn[1:rows(net.nconn)-1]
  ts = string ("A %.0f - %.0f - %.0f network:", net.n[1],net.n[2],net.n[3])
  ts = ts|string ("# weights     : %.0f", rows(net.conn))
  if (net.nunits > net.nsunits)
    ts = ts|"linear output : yes"
  else
    ts = ts|"linear output : no"
  endif
  if (net.entropy)
    ts = ts|"error function: entropy"
  else
    ts = ts|"error function: least squares"
  endif
  if (net.softmax)
    ts = ts|"log prob model: yes"
  else
    ts = ts|"log prob model: no"
  endif
  if (tconn[rows(tconn)]>net.n[2]+1)
    ts = ts|"skip links    : yes"
  else
    ts = ts|"skip links    : no"
  endif
  ts = ts|string("decay         : %g", net.decay)
  ts = ts|""|" From    To Weights"
  repl = paf ((1:net.nunits)-1, tconn.>0)
  repr = paf (tconn, tconn.>0)
  rep  = NaN
  i    = 0
  while (i<rows(repr))
    i   = i+1
    rep = rep|(repl[i].*matrix(repr[i]))
  endo
  rep = rep[2:rows(rep)]
  ts = ts|string ("%5.0f %5.0f %7.3g", net.conn, rep, net.wts)
endp
