proc()=salsa()
; -----------------------------------------------------------------
; Library       salsa
; -----------------------------------------------------------------
;  See_also                 
; -----------------------------------------------------------------
;   Macro       salsa
; -----------------------------------------------------------------
;   Description call a TRAMO-DLL
;      
; -----------------------------------------------------------------
;   Link                                                     
; -----------------------------------------------------------------
;   Usage        salsa()
;   Input
;     Parameter   
;     Definition        none     
;   Output
;     Parameter        
;     Definition               
; -----------------------------------------------------------------
;   Example   library("salsa")
;             salsa()
; -----------------------------------------------------------------
;   Result    Grafics of original and TRAMO-linearized series
;              
; -----------------------------------------------------------------
;   Author    Andreas Ruppin, 981020
; -----------------------------------------------------------------

  ;*****Einlesen der Daten
  xplreihe=read("BC_total.dat")
  original=xplreihe
  changed=original
  changed[15]=90000
  changed[30:33]=-99999
  changed[90]=10000
  ;*****Einlesen der Zeitparameter - zweite Zeile
  xplparam=read("BC.par")
  xplreihe=xplreihe|(0*matrix(2*xplparam[1]))
  xplreihechanged=changed|(0*matrix(2*xplparam[1]))
  tramoha=dlopen("tramo.so")
  contmain=1
  while(contmain)
    headmain = ""  
    itemmain = "Original Serie" | "Manipulated Original Serie" | "Break"    
    selmain = selectitem(headmain,itemmain)
    if(selmain[1])
      bild1=createdisplay(1,1)
      pm=(1:xplparam[1])'
      graf1=(1:xplparam[1])~original
      setmaskl(graf1,pm,4,1,2)
      setmaskp(graf1,4,3,4)
      show(bild1,1,1,graf1)
      setgopt(bild1,1,1,"title","Original Serie","ylim",0|11E4,"yvalue",0|1E4, "ymajor",2E04) 
      dlcall(tramoha,"MAIN__",xplreihe,xplparam)
      interpol=xplreihe[(xplparam[1]+1) : (2 * xplparam[1])]
      linear=xplreihe[(2 * xplparam[1]+1) : (3 * xplparam[1])]
      bild2=createdisplay(1,1)
      graf2=(1:xplparam[1])~linear
      setmaskl(graf2,pm,1,1,2)
      setmaskp(graf2,1,2,4)
      show(bild2,1,1,graf2) 
      setgopt(bild2,1,1,"title","Linear Serie","ylim",0|11E4,"yvalue",0|1E4, "ymajor",2E04) 
      head1 = "Both plots in one?"  
      item1 = "Yes" | "No"
      sel1 = selectitem(head1,item1)
      if(sel1[1])
        graf12=((1:xplparam[1]) | (1:xplparam[1])) ~ (original | linear)
        bild12=createdisplay(1,1) 
        pm12=((1:xplparam[1])')|( ((xplparam[1]+1) : (2*xplparam[1]))')    
        setmaskl(graf12, pm12, #(4,1) , 1, 2)
        color=4*matrix(xplparam[1]) | 1*matrix(xplparam[1])
        sy=3*matrix(xplparam[1]) |2*matrix(xplparam[1])
        setmaskp(graf12,color,sy,5)
        show(bild12,1,1,graf12)
        setgopt(bild12,1,1,"title","Original (red) and Linear (blue) Serie","ylim",0|11E4,"yvalue",0|1E4, "ymajor",2E04) 
      endif
      if(sel1[2])
      endif
    endif
    if(selmain[2])
      dlcall(tramoha,"MAIN__",xplreihechanged,xplparam)
      linearchanged=xplreihechanged[(2 * xplparam[1]+1) : (3 * xplparam[1])]
      bild3=createdisplay(1,1)
      graf3=(1:xplparam[1])~changed
      pm3=(1:xplparam[1])
      pm3[30:33]=0
      pm3=pm3'
      setmaskl(graf3,pm3,4,1,2)
      setmaskp(graf3,4,3,4)
      show(bild3,1,1,graf3)
      setgopt(bild3,1,1,"title","Manipulated Serie","ylim",0|11E4,"yvalue",0|1E4, "ymajor",2E04) 
      bild4=createdisplay(1,1)
      graf4=(1:xplparam[1])~linearchanged
      pm=(1:xplparam[1])'
      setmaskl(graf4,pm,1,1,2)
      setmaskp(graf4,1,2,4)
      show(bild4,1,1,graf4)
      setgopt(bild4,1,1,"title","Linear Manipulated Serie","ylim",0|11E4,"yvalue",0|1E4, "ymajor",2E04) 
      head2 = "Both plots in one?"  
      item2 = "Yes" | "No"
      sel2 = selectitem(head2,item2)
      if(sel2[1])
        graf34=((1:xplparam[1]) | (1:xplparam[1])) ~ (changed | linearchanged)
        bild34=createdisplay(1,1) 
        pm3=(1:xplparam[1])
        pm3[30:33]=0
        pm3=pm3'
        pm34= pm3 |( ( (xplparam[1]+1) : (2*xplparam[1]))')    
        setmaskl(graf34, pm34,#(4,1) , 1, 2)
        color=4*matrix(xplparam[1]) | 1*matrix(xplparam[1])
        sy=3*matrix(xplparam[1]) |2*matrix(xplparam[1])
        setmaskp(graf34,color,sy,3)
        show(bild34,1,1,graf34)
        setgopt(bild34,1,1,"title","Manipulated (red) and Linear Manipulated (blue) Serie","ylim",0|11E4,"yvalue",0|1E4, "ymajor",2E04) 
      endif
      if(sel2[2])
      endif
    endif
    if(selmain[3])
      contmain=0
    endif
  endo
  dlclose(tramoha)
endp