proc(output,betase,betastan,pval)=outputpar(colname,dfR,dfM,ybar,betain,x1,y1,MSSRin,MSSMin,Vin,Vi,k)
; -----------------------------------------------------------------------
; Library stats   
; -----------------------------------------------------------------------
; See_also outputbs outputfs2 outputanova    
; -----------------------------------------------------------------------
; Macro        outputpar
; -----------------------------------------------------------------------
; Description creates the parameter output for linregbs, linregfs, linregstep 
; -----------------------------------------------------------------------
; Notes to be used only in context with linear regression macros  or
;       in context with "doista"     
; -----------------------------------------------------------------------
  firstline="Variables in the Equation for Y:"
  secondline=" "
  bstr=string("b[%2.0f,]= %15.4f", 0:(rows(betain)-1), betain)  
  if(Vin<>0)
    variablestr=" Constant   "|string (" %s", colname[Vin])
  else
   variablestr=" Constant  "
  endif
  x=x1
  if(sum(Vi))
    y=y1[,,Vi]
  else
    y=y1
  endif
  ttestmatrix=(inv(x'*x))
  diagttestmatrix=xdiag(ttestmatrix)
  betase=sqrt(MSSRin*diagttestmatrix)
  betasestr=string("     %8.4f",betase)
  xbar=mean(x)
  xstddev=sqrt(sum((x.-xbar).*(x.-xbar)))	
  ystddev=sqrt(sum((y-ybar).*(y-ybar)))	
  sksy=trans(xstddev./ystddev)	  
  betastan=betain.*sksy
  betastanstr=string("     %8.4f",betastan)
  parfirstline="PARAMETERS         Beta         SE         StandB      t-test   P-value  Variable"   
  parsecondline="  __________________________________________________________________________________"
  tvalues=betain./(sqrt(MSSRin*diagttestmatrix))
  tvalstr=string("  %10.4f", tvalues) 
  tPvalues=2*(1-cdft(abs(tvalues),dfR))
  pval=tPvalues
  tPvalstr=string("   %1.4f  ", tPvalues)
  parametertext=""|parfirstline|parsecondline|bstr+betasestr+betastanstr+tvalstr+tPvalstr+variablestr
  output=firstline|secondline|parametertext
endp
	