proc(output)=outputstep(colname,result,dfM,dfR,Fin,Fout)
; -----------------------------------------------------------------------
; Library stats      
; -----------------------------------------------------------------------
; See_also outputbs outputfs2 outputpar outputanova    
; -----------------------------------------------------------------------
; Macro        outputstep
; -----------------------------------------------------------------------
; Description  creates the parameter output for linregstep
; -----------------------------------------------------------------------
; Notes        to be used only in context with the linear regression macros
;              or in context with "doista"
; -----------------------------------------------------------------------
 
  firstline ="Stepwise Regression"
  secondline="-------------------"
  secondlinea="Variables entered and dropped in the following Steps:"
  finstr=string("%4.2f",Fin)
  entry=cdff(Fin,dfM,dfR)
  entrystr=string("%3.2f",entry)
  thirdline="F-to-enter "+finstr
  fourthline="probability of F-to-enter "+entrystr 
  foutstr=string("%4.2f",Fout)
  out=cdff(Fout,dfM,dfR)
  outstr=string("%3.2f",out)
  thirdlinea="F-to-remove "+foutstr
  fourthlinea="probability of F-to-remove "+outstr
  fifthline="Step  Multiple R      R^2        F        SigF       Variable(s)"
;  colname=string("%15.15s",colname) 
  if(rows(result)==2)
    colname="Constant  "|colname
  endif
  inout = " In : "|" Out: "
  restr = string ("%2.0f ", result[,1])
  restr = restr+string ("%10.4f  ", result[,3])
  restr = restr+string ("%11.4f  ", result[,4])
  restr = restr+string ("%9.3f ", result[,5])
  restr = restr+string ("%8.3f ", result[,6])
  restr = restr+inout[result[,7]]
  res2  = paf(result, result[,2]<>NaN)
  restr = paf(restr, result[,2]<>NaN)
  restr = restr+string ("%s", colname[res2[,2]])
  output=firstline|secondline|thirdline|fourthline|thirdlinea|fourthlinea
  output=output|" "|secondlinea|""|fifthline|restr
endp
