proc(dummy)=pacfplot(x,maxlag)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  pacf,acf,acfplot,fft,invfft
; ----------------------------------------------------------------------
;   Macro	  pacfplot
; ----------------------------------------------------------------------
;   Description   plots the partial autocorrelation function
;                 of a time series.                
; ----------------------------------------------------------------------
;   Usage         pacfplot(x {, maxlag})
;   Input 
;     Parameter   x 
;     Definition  vector (time series)
;     Parameter   maxlag (optional)
;     Definition  Integer (maximum lag plotted, default 30)
; ----------------------------------------------------------------------
;   Example       library("times")
;                 x=normal(100)
;		              t = pacfplot(x)
; ----------------------------------------------------------------------
;   Result        generates a graphical object wich represents the 
;                 partial autocorrelation function of a time series
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970724
; ----------------------------------------------------------------------
if (exist(maxlag)==0)
  maxlag=30
endif
n=rows(x)
aa=pacf(x,maxlag)
bb=matrix(maxlag,2)*0
cc=vec((aa[1:maxlag]~bb)')
c1=1:(maxlag)
c2=2:(maxlag+1)
dd=vec((c1~c1~c2)')
dpacf=createdisplay(1,1)
w=dd~cc
w=setmask(w,"line", "solid")
s1=(1|maxlag)~((1|1)*2/sqrt(n))
s2=(1|maxlag)~((1|1)*(-2)/sqrt(n))
s1=setmask(s1,"line", "dashed")
s2=setmask(s2,"line", "dashed")
show(dpacf,1,1,w,s1,s2)
setgopt(dpacf,1,1,"xlabel","lag","ylabel","pacf" )
dummy=0
endp
