proc(y)=panlag(z,a,T) 
; ---------------------------------------------------------------------
; Library     metrics 
; ----------------------------------------------------------------------
; See_also    summarize
; ---------------------------------------------------------------------
; Macro       panlag 
; ---------------------------------------------------------------------
; Description Computes the lag of the variable
; ---------------------------------------------------------------------
; Usage       {zlag}=panlag(z,a, {T})
; Input       
; Parameter   z  Dataset
; Definition     NT x {2+} + k  Matrix
; Parameter   T  Number of time periods for a BALANCED Dataset
;                IMPORTANT: No column for the Index of Individuals!
;                (Optional, only for a Dataset with the same T
;                for all Individuals = BALANCED PANEL) 
; Definition     scalar
;             a  Konstante fr y(i,t)=(1-a)*z(i,t)+a*z(i,t-1)
; Definition     scalar
; Output      
; Parameter   zlag  Output matrix with (Ti-1)*N Observations
; Definition        string
; ---------------------------------------------------------------------
; Notes        
; ---------------------------------------------------------------------
; Example     z=read("dynpanel.dat")   ; read data set
;             it=z[,1:2]               ; Matrix of indices
;             z0=panlag(it~z[,4],0)    ; truncate first observation
;             z1=panlag(it~z[,4],1)    ; lag of second variable 
;             itlag=z0[,1:2]           ; new indices
;             dz2=z0[,3]-z1[,3]        ; differences of the second var.
; ---------------------------------------------------------------------
; Result      
; ---------------------------------------------------------------------
  NT=rows(z)
  k=cols(z)   

  if (exist(T)) 
    N=NT/T
    error(N-floor(N)>0,"  The data set is not balanced (NT/N is not an integer)")
    error(T<2,         "  T must be at least 2")
    if (T>0)
      N=NT/T
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      time=(1:T)  
      time=kron(matrix(N,1),time)
      z=ind~time~z
      k=k+2
    endif 
  endif	

  pos=1
  y=matrix(1,k)
  while(pos < NT-1) 
    ind=z[pos,1]
    time0=z[pos,2]
    zi=z[pos,]
    pos=pos+1
    while (z[pos,1]==ind)
      time1=z[pos,2] 
      if (time0==time1-1)
        zi=zi|z[pos,] 
      endif
      time0=time1
      pos=pos+1
    endo
    Ti=rows(zi)

    if (Ti>4)
      lagy=(1-a)*zi[2:Ti,3:k]+a*zi[1:Ti-1,3:k]
      lagy=zi[2:Ti,1:2]~lagy
      y=y|lagy 
    endif
  endo
  y=y[2:rows(y),]

  if (exist(T)) 
    y=y[,3:k]
  endif

endp


