proc(w)=parzen(x,t)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  spec
; ----------------------------------------------------------------------
;   Macro	  parzen
; ----------------------------------------------------------------------
;   Description   calculates the parzen window              
; ----------------------------------------------------------------------
;   Usage         w=parzen(x,t)
;   Input 
;     Parameter   x 
;     Definition  grid on which the function is calculated
;     Parameter   t
;     Definition  truncation point
;   Output
;     Parameter   w
;     Definition  Parzen window
; ----------------------------------------------------------------------
;   Example       library("times")
;                 parzen(0,9)  
; ----------------------------------------------------------------------
;   Result        Contents of w
;                 [1,]   6.75 
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970723
; ----------------------------------------------------------------------
w=12/t^3.*(sin(pi*x*t/2)./sin(pi*x)).^4.*(1-2/3*(sin(pi*x)).^2)
w=replace(w,NaN,0.75*t)
endp