proc(ret)=pdfbin(n,p,x)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     cdfbin, qfbin, randbin
; -----------------------------------------------------------------------
; Macro        pdfbin
; -----------------------------------------------------------------------
; Description  computes the probability function of a binomial 
;              distribution B(n,p) at a grid x
; -----------------------------------------------------------------------
; Usage        ret = pdfbin (n, p, x)
; Input        
;   Parameter  n
;   Definition scalar
;   Parameter  p
;   Definition scalar
;   Parameter  x
;   Definition m x 1 vector of integer numbers (0<=x<=n)
; Output       
;   Parameter  ret
;   Definition m x 1 vector of probabilities
; -----------------------------------------------------------------------
; Example      library ("stats")
;              pdfbin(3, 0.5, 0:3)  
; -----------------------------------------------------------------------
; Result       Contents of ret
;              [1,]    0.125 
;              [2,]    0.375 
;              [3,]    0.375 
;              [4,]    0.125        
; -----------------------------------------------------------------------
; Example      library ("stats")
;              (0:4)~pdfbin(4, 0.1, 0:4)  
; -----------------------------------------------------------------------
; Result       Contents of _tmp
;              [1,]        0   0.6561 
;              [2,]        1   0.2916 
;              [3,]        2   0.0486 
;              [4,]        3   0.0036 
;              [5,]        4   0.0001 
; -----------------------------------------------------------------------
; Author       SK, WH, 981231
; -----------------------------------------------------------------------
; Keywords     binomial, binomial distribution			
; -----------------------------------------------------------------------
  ret = 0*x
  i   = 0
  while (i<rows(x))
    i=i+1
    switch 
    case (x[i]==0)
      ret[i] = exp(n*log(1-p))
      break
 		case (x[i]==n)
      ret[i] = exp(n*log(p))
      break
    case ((x[i]>0) && (x[i]<n))    
      ret[i] = exp(x[i]*log(p)+(n-x[i])*log(1-p)+sum(log(n:(n-x[i]+1)))-sum(log(1:x[i])))
      break
    endsw
  endo
endp
