proc (peri) = pgram (x, opt) 
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  fft, invfft, spec 
; ----------------------------------------------------------------------
;   Macro	  pgram
; ----------------------------------------------------------------------
;   Description   computes and plots the raw (log) periodogram 
;                 of a time series
; ----------------------------------------------------------------------
;   Usage         y = pgram(x {,opt})
;   Input 
;     Parameter   x 
;     Definition  vector
;     Parameter   opt (optional)
;     Definition  integer; If opt=1 (Default) the periodogram is returned, 
;                 otherwise the log periodogram
;   Output
;     Parameter   y
;     Definition  vector
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize (0)
;                 x=genarma(0.9,0,normal(100))
;		              y=pgram(x)
;                 y[1:5]
; ----------------------------------------------------------------------
;   Result        generates a graphical object wich represents the 
;                 periodogram of a time series  
;
;                 Contents of _tmp
;                 [1,]   50.882 
;                 [2,]   42.724 
;                 [3,]   40.861 
;                 [4,]   13.082 
;                 [5,]   7.3546 
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970725
; ----------------------------------------------------------------------
  if (exist(opt)==0)
    opt=1   
  endif
  n = rows(x) 
  x = x-mean(x)
  p = log(n) / log(2)
  p = rint(exp(log(2)*ceil(p)))            ; next power of 2 
  if (n != p)
    x = x|(matrix(p-n)-1)                  ; append series 
  endif
  x=x~(matrix(p).*0)
  ftr = fft(x)                             ; fourier transform
  peri = (sum((ftr.*ftr)')/p)'            ; periodogram
  ind=2:(floor(n/2))
  peri = peri[ind]
  dpgram=createdisplay(1,1)
  if(opt<>1)
    peri=log(peri)
  endif
  w=setmask((ind/n)~peri, "line", "solid")
  show(dpgram,1,1,w)
  setgopt(dpgram,1,1,"xlabel","frequency","ylabel","periodogram" )
endp
