proc(hbetals,hbeta,hg0,hg)=plmhetexog(x,t,y,w,h,h1)
; -----------------------------------------------------------------
;    Library	plm
; -----------------------------------------------------------------
;    See_also plmhett, plmhetmean
; -----------------------------------------------------------------
;    Macro	plmhetexog
; -----------------------------------------------------------------
;    Description   plmhetexog estimates the parameter part in partially 
;		   linear heteroscedastic models, in which the variance
;		   is an unknown function of exogenous variables
; -----------------------------------------------------------------
;    Usage    res = plmhetexog(x,t,y,w,h,{h1})
;    Input
;      Parameter  x
;      Definition   n x p matrix, the design
;      Parameter  t
;      Definition   n  x 1 matrix, the design in [0, 1]
;      Parameter  y
;      Definition   n x 1 matrix, the response
;      Parameter  w
;      Definition   n x 1 matrix, the response
;      Parameter  h
;      Definition  p x 1 matrix or scalar, chosen bandwidth
;      Parameter  h1
;      Definition  scalar, chosen bandwidth
;    Output
;      Parameter  res.hbetals
;      Definition   p x 1 matrix, LS estimate of parameter
;      Parameter  res.hbeta
;      Definition   p x 1 matrix, the estimate based on our method
;      Parameter  res.hg0
;      Definition   n x 1 matrix, estimate of nonparameter function
;		    based on res.hbetals
;      Parameter  res.hg
;      Definition   n x 1 matrix, estimate of nonparameter function
;		    based on res.hbeta
; -----------------------------------------------------------------
;  Example library("plm")
;          randomize(100)
;	   n = 100
;	   sig=0*matrix(3,3)
;	   sig[,1]=#(0.81,0.1,0.2)
;	   sig[,2]=#(0.1,2.25,0.1)
;	   sig[,3]=#(0.2,0.1,1)
;	   x =normal(n,3)*sig  
;	   t =sort(uniform(n))
;          w =sort(uniform(n)^3)
;          beta0=#(1.2, 1.3, 1.4)  ; the true value
;	   y =x*beta0+t^3+0.1*(w+5/(1+w)).*normal(n)
;	   h =0.15
;	   res=plmhetexog(x,t,y,w,h)
;          res
;;;;;;;;;;;;;;;;for non-parametric part
;          ddp=createdisplay(1,1)
;          datah1=t~t^3
;          datah2=t~res.hg0
;          datah3=t~res.hg 
;          part=grid(1,1,rows(t))'
;          setmaskp(datah1,1,0,1)
;          setmaskp(datah2,4,0,3)
;          setmaskp(datah3,7,0,5)
;          setmaskl(datah1,part,1,1,1)
;          setmaskl(datah2,part,4,1,3)
;          setmaskl(datah3,part,2,1,1)
;          show(ddp,1,1,datah1,datah2,datah3)
;          setgopt(ddp,1,1,"xlabel","T","title","Simulation comparison","ylabel","g(T) and its estimate values")
;-----------------------------------------------------------------
;    Result   The parameter estimates, see Hua Liang and Wolfgang
; Haerdle" Asymptotic normality of parametric regression part in
; partial linear heteroscedastic regression models",
; DP 970033 of SFB 373.
; -----------------------------------------------------------------
;   Author    Hua Liang, 12.05.1998
; -----------------------------------------------------------------
n=rows(x)
p=cols(x)
  if(exist(h1)==0)
    h1=h[1]     ; default is h[1]
  endif
Pn=matrix(n)
       uv = sort(t~Pn~y~x~w,1)
       st = uv[,1]
       sy = uv[,3:p+3]
       Tj = sker(st,h,"qua",Pn~sy,st)
       tj = Tj[,1]
       yj = Tj[,2]
       xj = Tj[,3:p+2]
 tx=x-xj/tj
 ty=y-yj/tj
 hbetals=inv(tx'*tx)*(tx'*ty)  ; LS estimator
 hg0=yj/tj-(xj/tj)*hbetals
;;;;;;;;;;; constructing the estimator of sigma_i^2
 err0=(y-x*hbetals-hg0).^2
     uv1=sort(w~err0,1)
     sw=uv1[,1]
     serr0=uv1[,2]
     Tj1=sker(sw,h1,"qua",Pn~serr0,sw)
     wj=Tj1[,1]
     errj=Tj1[,2]
 hHw=sqrt(errj/wj)   ; the estimate of sigma_i
 hbeta=inv((hHw.*tx)'*tx)*((hHw.*tx)'*ty)  ; the final estimate of beta
hg=yj/tj-(xj/tj)*hbeta
endp
