proc(hbeta,hsigma,hg)=plmk(x,t,y,h)
; -----------------------------------------------------------------
;    Library	plm
; -----------------------------------------------------------------
;    See_also plmlorg, plmp
; -----------------------------------------------------------------
;    Macro	plmk
; -----------------------------------------------------------------
;    Description   plmk estimates the parameter part in partially 
;		   linear models by using kernel to approximate 
;		   the nonparametric part
; -----------------------------------------------------------------
;    Usage    res = plmk(x,t,y,h)
;    Input
;      Parameter  x
;      Definition   n x p matrix, the design
;      Parameter  t
;      Definition   n  x 1 matrix, the design in [0, 1]
;      Parameter  y
;      Definition   n x 1 matrix, the response
;      Parameter  h
;      Definition  p x 1 matrix or scalar, chosen bandwidth
;    Output
;      Parameter  res.hbeta
;      Definition   p x 1 matrix, estimate of parameter
;      Parameter  res.hsigma
;      Definition   scalar, estimate of variance
;      Parameter  res.hg
;      Definition   n x 1 matrix, estimate of nonparameter function
; -----------------------------------------------------------------
;  Example library("plm")
;	   n = 100
;	   sig=0*matrix(3,3)
;	   sig[,1]=#(0.81,0.1,0.2)
;	   sig[,2]=#(0.1,2.25,0.1)
;	   sig[,3]=#(0.2,0.1,1)
;	   x =normal(n,3)*sig  
;	   t =sort(uniform(n))
;          beta0=#(1.2, 1.3, 1.4)  ; the true value
;	   y =x*beta0+t^3+0.01*normal(n)
;	   h =0.5
;	   res=plmk(x,t,y,h)
;          res.hbeta               ; the estimate of beta
;          res.hsigma              ; the estimate of the variance when error is homoscedastic
;          ddp=createdisplay(1,1)
;          datah1=t~t^3
;          datah2=t~res.hg
;          part=grid(1,1,rows(t))'
;          setmaskp(datah1,1,0,1)
;          setmaskp(datah2,4,0,3)
;          setmaskl(datah1,part,1,1,1)
;          setmaskl(datah2,part,4,1,3)
;          show(ddp,1,1,datah1,datah2)
;          setgopt(ddp,1,1,"xlabel","T","title","Simulation comparison","ylabel","g(T) and its estimate values")
;-----------------------------------------------------------------
;    Result   The parameter estimates, see Jiti Gao, Shengyan Hong and
; Hua Liang" Convergence rate in partly linear models",
; Acta Mathematical Sinica (1995) 17, 170-180.
; -----------------------------------------------------------------
;   Author    Hua Liang, 98
; -----------------------------------------------------------------
n=rows(x)
p=cols(x)
Pn=matrix(n)
       uv = sort(t~Pn~y~x,1)
       st = uv[,1]
       sy = uv[,3:p+3]
       Tj = sker(st,h,"qua",Pn~sy,st)
       tj = Tj[,1]
       yj = Tj[,2]
       xj = Tj[,3:p+2]
 tx=x-xj/tj
 ty=y-yj/tj
 hbeta=inv(tx'*tx)*(tx'*ty)
 hsigma=mean((ty-tx*hbeta).^2)
 hg=yj/tj-(xj/tj)*hbeta
endp
