library("smoother")
proc(hbeta,hg)=plmlorg(t,x,y,h,p)
; -----------------------------------------------------------------
;    Library	plm
; -----------------------------------------------------------------
;    See_also plmk, plmp
; -----------------------------------------------------------------
;    Macro	plmlorg
; -----------------------------------------------------------------
;    Description   plmlorg estimates the parameter part in partially
;		   linear models by local polynomail to approximate
;		   the nonparametric part
; -----------------------------------------------------------------
;    Usage    res = plmlorg(x,t,y,h,{p})
;    Input
;      Parameter  t
;      Definition   n  x 1 matrix, the design in [0, 1]
;      Parameter  x
;      Definition   n x m matrix, the design
;      Parameter  y
;      Definition   n x 1 matrix, the response
;      Parameter  h
;      Definition  m x 1 matrix or scalar, chosen bandwidth
;    Output
;      Parameter  res.hbeta
;      Definition   m x 1 matrix, estimate of parameter
; -----------------------------------------------------------------
;  Example library("plm")
;	   n = 100
;	   sig=0*matrix(3,3)
;	   sig[,1]=#(0.81,0.1,0.2)
;	   sig[,2]=#(0.1,2.25,0.1)
;	   sig[,3]=#(0.2,0.1,1)
;	   x =normal(n,3)*sig
;	   t =sort(uniform(n))
;	   beta0=#(1.2, 1.3, 1.4)  ; the true value
;	   y =x*beta0+t^3+0.01*normal(n)
;	   h =0.25
;	   res=plmlorg(t,x,y, h,1)
;	   res.hbeta		; the estimate of beta
;	   ddp=createdisplay(1,1)
;	   datah1=t~t^3
;	   datah2=t~res.hg
;	   part=grid(1,1,rows(t))'
;	   setmaskp(datah1,1,0,1)
;	   setmaskp(datah2,4,0,3)
;	   setmaskl(datah1,part,1,1,1)
;	   setmaskl(datah2,part,4,1,3)
;	   show(ddp,1,1,datah1,datah2)
;	   setgopt(ddp,1,1,"xlabel","T","title","Simulation comparison","ylabel","g(T) and its estimate values")
;-----------------------------------------------------------------
;    Result
; -----------------------------------------------------------------
;   Author    Hua Liang, 98
; -----------------------------------------------------------------
n=rows(x)
k=cols(x)
  if(exist(p)==0)
    p=1 	 ; default is local linear
  endif
  lx=0*matrix(101,k)
  i=1
  while(i<=k)
   lx[,i]=lpregest(t~x[,i],h,p)[,2] ;the estimate of x
  i=i+1
  endo
  lty=lpregest(t~y,h,p)
  lt=lty[,1]  ; grids
  ly=lty[,2]  ; the estimate of y
ex=0*matrix(n,k+1)
;
  i=2
  while(i<n)
  pz2=(paf(lt~lx~ly,lt>=t[i])[1,])'
  pz1=(-sort(-paf(lt~lx~ly,lt<t[i]))[1,])'
ex[i,]=(pz2[2:k+2]-(pz2[2:k+2]-pz1[2:k+2])./(pz2[1]-pz1[1])*(pz2[1]-t[i]))'
  i=i+1
ex[1,]=lx[1,]~ly[1]
ex[n,]=lx[101,]~ly[101]
  endo
;
 tx=x-ex[,1:k]
 ty=y-ex[,k+1]
 hbeta=inv(tx'*tx)*(tx'*ty)
 hg=ex[,k+1]-ex[,1:k]*hbeta
endp
