proc()=plotir(ir, label0,value0, label1,value1, label2,value2, label3,value3, label4,value4, label5,value5, label6,value6, label7,value7, label8,value8, label9,value9)
; -----------------------------------------------------------------
;   Library      plot
; -----------------------------------------------------------------
;   See_also     impres, varunls
; -----------------------------------------------------------------
;   Macro    plotir        
; -----------------------------------------------------------------
;   Description Plots impulse response functions (ir) of a
;               K-dimensional VAR(p) optionally with up to four
;               different confidence intervals or confidence 
;               limits. Different methods for computing
;               confidence intervals for impulse responses are thus
;               graphically comparable. Optionally, the
;               appearance of the graphical output can be controlled. 
; -----------------------------------------------------------------
;   Usage       plotir(ir {, optionname1, optionvalue1} {, optionname2, optionvalue2} { ... })   
;   Input
;     Parameter   ir     
;     Definition  (N x K^2) matrix, impulse response functions,
;                 each column represents a specific impulse response function
;                 over time. The first K columns of ir are the responses of the
;                 first variable on an impulse in the first, second,...,K-th
;                 variable, the second K columns are the responses of the second
;                 variable on an impulse in the first, second,...,K-th
;                 variable, and so on. The first row is set with time
;                 zero.            
;     Parameter   optionname1 ... optionname10
;     Definition  String. Following option names are valid:
;                 "variables" - user can specify variable names
;                 "impulse"   - which impulse variables are plotted
;                 "response"  - which response variables should be displayed
;                 "labels"    - specify the names labels
;                 "explain"   - should the plot matrix be explained?              
;                 "scale"     - scaling preferences
;                 "cb1"       - confidence bound 1
;                 "cb2"       - confidence bound 2
;                 "cb3"       - confidence bound 3
;                 "cb4"       - confidence bound 4
;                              
;     Parameter   optionvalue1 ... optionvalue10
;     Definition  values according to the before specified option name.
;                 The following optionvalues are valid.
;                 optionname      optionvalue
;                 "variables"   - vector of strings, e.g. "ln GNP"|"ln M1"|"r"
;                                 default: "y1"|"y2"|...|"yK"
;                 "impulse"     - vector of integers, that specifies the impulse 
;                                 variables that appear in the plot, e.g. 2|3
;                                 default: 1|2|...|K
;                 "response"    - vector of integers, that specifies the response 
;                                 variables that appear in the plot, e.g. 1|3
;                                 default: 1|2|...|K
;                 "labels"      - vector of strings, e.g. "Estimated i.r."|"CI 1"
;                                 default: no labels are plotted
;                 "explain"     - integer, 0 (no explanation) or 1 (aditional explanation)
;                                 default: 1              
;                 "scale"       - string: "sep", "row", "col", or "all"
;                                 default: "sep"
;                 "cb1"..."cb4" - (  irmax+1    x  K^2) - matrix, or
;                                 (2*(irmax+1)  x  K^2) - matrix
;
;
;
;   Output                                                           
;     Parameter   
;     Definition  Graphs on display 
; -----------------------------------------------------------------
;   Author Benkwitz 980127
; -----------------------------------------------------------------
;
;
;
keywords = "variables"|"impulse"|"response"|"labels"|"explain"|"scale"|"cb1"|"cb2"|"cb3"|"cb4"
register = list("none",0,0,"none",1,"sep",0,0,0,0)
switch
   case (exist (label0))
       position = maxind(label0.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label0~" unknown."
       else
           register{ position } = value0
       endif
   case (exist (label1))
       position = maxind(label1.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label1~" unknown."
       else
           register{ position } = value1   
       endif
   case (exist (label2))   
       position = maxind(label2.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label2~" unknown."
       else
           register{ position } = value2
       endif
   case (exist (label3))
       position = maxind(label3.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label3~" unknown."
       else
           register{ position } = value3
       endif
   case (exist (label4))
       position = maxind(label4.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label4~" unknown."
       else
           register{ position } = value4
       endif
   case (exist (label5))   
       position = maxind(label5.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label5~" unknown."
       else
           register{ position } = value5
       endif
   case (exist (label6))   
       position = maxind(label6.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label6~" unknown."
       else
           register{ position } = value6
       endif
   case (exist (label7))
       position = maxind(label7.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label7~" unknown."
       else
           register{ position } = value7
       endif
   case (exist (label8))   
       position = maxind(label8.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label8~" unknown."
       else
           register{ position } = value8
       endif
   case (exist (label9))  
       position = maxind(label9.==keywords)
       if (position==0)
           "ERROR while running xplore-program:"|"option name "~label9~" unknown."
       else
           register{ position } = value9
       endif
endsw
;
;
;
k     = rint(sqrt(cols(ir)))   	; number of endogenous variables
irmax = rows(ir)                ; number of impulse responses (incl. zero response)
cbindex = 1                     ; some code, just to make the plot layout and label layout look the same
;
;
; assign optional parameters to procedure parameters or setting defaults
;
if (register{1}=="none")    ; variable names
    names = string("y%1.0f", 1:k)
else
    names = register{1}
    if (!(rows(names)==k))
        "ERROR while running xplore-program:"|"Number of variable names does not equal number of equations in the system."|"Therefore, set to default." 
        names = string("y%1.0f", 1:k)
    endif
endif
;
if (register{2}==0)         ; impulse equations 
    impulse = 1:k
else
    impulse = register{2}
endif
;
if (register{3}==0)         ; response equations 
    response = 1:k
else
    response = register{3}
endif
;
graphlabels = register{4} ; graph labels
;
describe    = register{5} ; explain impulse response matrix
;
scale       = register{6} ; scaling option
;
if (!(register{7}==0))     ; '!' means not, '||' means or
    if ((rows(register{7})==irmax)||(rows(register{7})==2*irmax)) 
        ci1=register{7}
        cbindex=cbindex|2
    else
        "ERROR when running the xplore-program:"|"'cb1' cannot be read and will not be displayed."
    endif
endif
;
if (!(register{8}==0))
    if ((rows(register{8})==irmax)||(rows(register{8})==2*irmax)) 
        ci2=register{8}
        cbindex=cbindex|3
    else
        "ERROR when running the xplore-program:"|"'cb2' cannot be read and will not be displayed."
    endif
endif
;
if (!(register{9}==0))
    if ((rows(register{9})==irmax)||(rows(register{9})==2*irmax)) 
        ci3=register{9}
        cbindex=cbindex|4
    else
        "ERROR when running the xplore-program:"|"'cb3' cannot be read and will not be displayed."
    endif
endif
;
if (!(register{10}==0))
    if ((rows(register{10})==irmax)||(rows(register{10})==2*irmax)) 
        ci4=register{10}
        cbindex=cbindex|5
    else
        "ERROR when running the xplore-program:"|"'cb4' cannot be read and will not be displayed."
    endif
endif
;
;
;
artcode   = 1|15|2|7|1|15
colorcode = 0|1|4|2|4
thickcode = 1|1|1|2|1
i       = 1                   		 		   			; row index 	of display
j       = 1                    			   				; column index 	of display
re      = rows(response)
im      = rows(impulse)
xgrid	= 0:irmax-1  							   	; grid  for x-axis    
;zeroline= #(xgrid[1]-1,xgrid[rows(xgrid)]+1)~#(0,0)
connect	= (xgrid+1)'     						   		; connection matrix
;
;  creating main display:
;
display1 = createdisplay(re + describe,im + describe)				  		; open display
if (describe==1)
    rowfrac  = 10 | 90./aseq(re,re,0) 
    colfrac  = 20 | 80./aseq(im,im,0) 
    setfractions(display1,rowfrac,colfrac)
    ;
    ;
    ; "Impulse in..."-label:
    textgrid=aseq(1,5,0)|aseq(2,5,0)|aseq(10,5,0)
    textgrid=textgrid~(aseq(5,5,-1)|aseq(5,5,-1)|aseq(5,5,-1))
    setmaskp(textgrid, 7, 0, 0)
    text = textgrid[2,]|textgrid[9,]
    setmaskp(text    , 7, 0, 0)
    i	= 1
    do
        if (i==1)
            setmaskt(text, "Impulse in"|names[impulse[i]], 0, 3, 16)
        else
            setmaskt(text, "          "|names[impulse[i]], 0, 3, 16)
        endif
        show(display1, 1, i+1, textgrid, text)  
        i = i + 1
    until (i==im+1)
    ;
    ; 
    ; "Response of..."-label:
    textgrid=aseq(1,3,0)|aseq(2,3,0)|aseq(5,3,0)|aseq(9,3,0)|aseq(10,3,0)
    textgrid=textgrid~(aseq(3,3,-1)|aseq(3,3,-1)|aseq(3,3,-1)|aseq(3,3,-1)|aseq(3,3,-1))
    setmaskp(textgrid, 7, 0, 0)
    text=textgrid[1,]|textgrid[5,]
    setmaskp(text    , 7, 0, 0)
    i=1
    do
        if (i==1)
            setmaskt(text, "Response of"|names[response[i]], 0, 3, 16);
        else
            setmaskt(text, "           "|names[response[i]], 0, 3, 16);
        endif;
        show(display1, i+1, 1, textgrid, text)
        i = i + 1
    until (i==re+1)
endif
;
;computing the scales, and major tickmarks
;
scales = matrix(4,cols(ir)) ; row1:=ymin    row2:=ymax  row3:=majorticks
i      = 1
j      = 1
do
  ; 
  ; column index for impulse response matrices
  ;
  switch
      case (scale=="row")
          ind = (response[i]-1)*k + impulse
          i = i + 1
          break
      case (scale=="col")
          ind = ((response-1)*k).+impulse[j]
          j = j + 1
          if (j>im)
             i=re+1
          endif         
          break
      case (scale=="all")
          ind = vec(   ( ((response-1)*k).+impulse' )'   )
          i = re + 1
          break
      default 
          ind=(response[i]-1)*k+impulse[j]
          j=j+1
          if (j>im)
             j=1
             i=i+1
          endif
  endsw
  ;
  ;
  ;
  ymax  = max( vec(ir[,ind]) )
  ymin  = min( vec(ir[,ind]) )
  switch
    case (exist (ci1))
      ymax = max( vec(ci1[,ind])|ymax )
      ymin = min( vec(ci1[,ind])|ymin )
    case (exist (ci2))
      ymax = max( vec(ci2[,ind])|ymax )
      ymin = min( vec(ci2[,ind])|ymin )
    case (exist (ci3))
      ymax = max( vec(ci3[,ind])|ymax )
      ymin = min( vec(ci3[,ind])|ymin )
    case (exist (ci4))
      ymax = max( vec(ci4[,ind])|ymax )
      ymin = min( vec(ci4[,ind])|ymin )
  endsw
  ;
  ; lower ymin by 5% - just to make graphs look nicer
  ;
  ymin = ymin - .05*(ymax - ymin)  
  ;
  ; higher ymax by 5%
  ymax = ymax + .05*(ymax - ymin)
  ;
  ; setting ticksteps and reducing them
  ;
  {a,b}=floatinf(.2*(ymax - ymin)) 
  a=minind(abs((1:5)-rint(a))) 
  if ((a==3)||(a==4))
    a=5
  endif
  major=a*10^b
  if (b<-2)
    kk=b
  else
    kk=1
  endif
  ;
  ;
  ;
  scales[,ind] = ymin | ymax | major | kk
until (i==re+1)
;
; plotting impulse responses and confidence bounds
;
i = 1
j = 1
do
  ; 
  ; column index for impulse response matrices
  ;
  ind=(response[i]-1)*k+impulse[j]
  ;
  ; plotting impulse response function
  ;
  data=xgrid~ir[,ind]
  setmaskp( data, 0, 0, 0)
  setmaskl( data, connect, colorcode[1], artcode[1], thickcode[1])
  show( display1, i+describe, j+describe, data)
  if (i==j) ; different origin for ticks at y-axis
	setgopt( display1, i+describe , j+describe, "xlim",0|(rows(ir)-1),"ylim",scales[1:2,ind],"ymajor",scales[3,ind],"yorigin",1,"xlabel"," ","ylabel"," ")	
  else 
;	setgopt( display1, i+describe , j+describe, "xlim",0|(rows(ir)-1),"ylim",scales[1:2,ind],"ymajor",scales[3,ind],"yorigin",0,"xlabel"," ","ylabel"," ")	
	setgopt( display1, i+describe , j+describe, "xlim",0|(rows(ir)-1),"ylim",scales[1:2,ind],"ymajor",scales[3,ind],"yvalue",0|scales[4,ind],"yorigin",0,"xlabel"," ","ylabel"," ")	
  endif
  ;
  ;
  ; plotting confidence intervals
  ;
  switch
    case (exist (ci1))
      if (rows(ci1)==irmax)
          data=xgrid~ci1[,ind]
          connectdata=connect
      else
          data=(xgrid|xgrid)~ci1[,ind]
          connectdata=connect|(irmax+connect)
      endif
      setmaskp (data,0,0,0)
      setmaskl (data, connectdata, colorcode[2], artcode[2], thickcode[2])
      adddata( display1, i+describe, j+describe, data)
    case (exist (ci2))
      if (rows(ci2)==irmax)
          data=xgrid~ci2[,ind]
          connectdata=connect
      else
          data=(xgrid|xgrid)~ci2[,ind]
          connectdata=connect|(irmax+connect)
      endif
      setmaskp (data,0,0,0)
      setmaskl (data, connectdata, colorcode[3], artcode[3], thickcode[3])
      adddata( display1, i+describe, j+describe, data)
    case (exist (ci3))
      if (rows(ci3)==irmax)
          data=xgrid~ci3[,ind]
          connectdata=connect
      else
          data=(xgrid|xgrid)~ci3[,ind]
          connectdata=connect|(irmax+connect)
      endif
      setmaskp (data,0,0,0)
      setmaskl (data, connectdata, colorcode[4], artcode[4], thickcode[4])
      adddata( display1, i+describe, j+describe, data)
    case (exist (ci4))
      if (rows(ci4)==irmax)
          data=xgrid~ci4[,ind]
          connectdata=connect
      else
          data=(xgrid|xgrid)~ci4[,ind]
          connectdata=connect|(irmax+connect)
      endif
      setmaskp (data,0,0,0)
      setmaskl (data, connectdata, colorcode[5], artcode[5], thickcode[5])
      adddata( display1, i+describe, j+describe, data)
  endsw
  ;
  ; plotting zero line
  ;
  zeroline= #(xgrid[1]-.01,xgrid[rows(xgrid)]+.01)~#(0,0)
  setmaskp(zeroline,0,0,0)
  setmaskl(zeroline,#(1,2)',0,1,1)
  adddata( display1, i+describe, j+describe, zeroline) 
  ;
  ;
  ;
  j=j+1
  if (j>im)
    j=1
    i=i+1
  endif
until (i==re+1)
;
;  creating display for labels:
;
if (!(graphlabels=="none"))
    nolabels=rows(graphlabels) ; number of labels
    i=nolabels                 ; 'i' is a counter 
    linegrid=(0|.2|1.8|2|10)
    textgrid=linegrid~aseq(i+.5,rows(linegrid),0)    ; upper line
    textgrid=textgrid|(linegrid~aseq(i,rows(linegrid),0))
    i=i-1
    while (!(i==0))
        textgrid=textgrid|(linegrid~aseq(i,rows(linegrid),0) )
        i=i-1
    endo
    textgrid=textgrid|(linegrid~aseq(.5,rows(linegrid),0))    ; lower line
    setmaskp(textgrid,0,0,0)
    ;
    ; creating resized display
    ;
    setsize(500,20+20*nolabels)
    display2 = createdisplay(1,1)
    setsize(500,500)
    ;
    ; creating line data
    ;
    lines=aseq( 7, nolabels, 5) ; index-vektor
    lines=sort(lines|(lines+1), 1)
    lines=textgrid[lines,]
    setmaskp(lines, 0, 0, 0)
    setmaskl(lines, reshape(1:rows(lines), 2|(rows(lines)/2))', colorcode[cbindex], artcode[cbindex], thickcode[cbindex]) 
    ;
    ; creating label data
    ;
    text=aseq( 9, nolabels, 5) ; index-vektor
    text=textgrid[text,]
    setmaskp(text, 0, 0, 0)
    setmaskt(text, graphlabels, 0, 3, 16)
    ;
    ;
    ;
    axesoff()
    show(display2,1,1,textgrid,lines,text)
    axeson()
endif
;
;
;
header = "Program stopped for Displaying Plots."
option = "Continue"
selection = selectitem(header, option, "single")
display1 = 0
display2 = 0
;
;
;
endp
