proc() = plotpcp (x, prep, col)
; -----------------------------------------------------------------------
; Library      plot
; -----------------------------------------------------------------------
; See_also     grpcp plot2 plotandrews plotsplom plotgt
; -----------------------------------------------------------------------
; Macro        plotpcp
; -----------------------------------------------------------------------
; Description  Plots a parallel coordinates plot from a multivariate dataset.
; -----------------------------------------------------------------------
; Usage        plotpcp (x {, prep {, col}})
; Input
;   Parameter  x
;   Definition n x p matrix
;   Parameter  prep
;   Definition scalar
;   Parameter  col
;   Definition color
; -----------------------------------------------------------------------
; Notes        prep allows some transformation of the data:
;
;              grc.prep.none (0) - no transformation
;
;              grc.prep.standard (1) - standardize
;
;              grc.prep.zeroone (2) - to [0,1]  (default)
;
;              grc.prep.pcacov (3) - pca on cov matrix
;
;              grc.prep.pcacorr (4) - pca on corr matrix
;
;              grc.prep.sphere (5) - sphering
; -----------------------------------------------------------------------
; Example      ; loads the library plot
;              library ("plot")
;              ; reads the swiss banknote data (200x6)
;              x = read("bank2")
;              ; computes the principal components of x as parallel
;              ; coordinate plot
;              plotpcp (x, grc.prep.pcacov)
; -----------------------------------------------------------------------
; Result       shows the principal components of x as a parallel
;              coordinate plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords    high level graphics, parallel coordinate plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970201
; -----------------------------------------------------------------------
  grc = getglobal ("grc")  
  if (exist("prep").<>1)
    prep = grc.prep.zeroone
  endif
  if (exist("col").<>1)
    col = grc.col.black
  endif
  y = transform (x, prep)
  gry = grpcp (y, col)
  grdisp = createdisplay(1,1)
  show (grdisp, 1, 1, gry)
endp
