proc(d)=portmant(b,resva,tb,te,t,di,ord,adj,h,df,typ,ts,outp)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      normalt
; -----------------------------------------------------------------
;   Macro         portmant
; -----------------------------------------------------------------
;   Description   calculates the multivariate portmanteau statistic
; -----------------------------------------------------------------
;   Usage         d = portmant(b,resva,tb,te,t,di,ord,adj,h,df,typ,ts,outp)
;   Input
;     Parameter   b 
;     Definition    matrix 
;     Parameter   resva 
;     Definition    matrix, variance of rediduals
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   t 
;     Definition    integer, number of observation time points
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   adj 
;     Definition    scalar, 1=if adjusted, 0=if not
;     Parameter   h 
;     Definition    integer, forecast horizon
;     Parameter   df 
;     Definition    integer, degrees of freedom
;     Parameter   typ 
;     Definition    integer, describing the model type
;     Parameter   ts
;     Definition    matrix
;     Parameter   outp
;     Definition    matrix 
;   Output
;     Parameter   d
;     Definition     matrix 
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971212
; -----------------------------------------------------------------
 if  ((typ == 6)||(typ == 7))
    u=resva;
 else;
    u=residuen(b,ord,di,adj,tb,te,ts);
 endif;
 c0=1/t*u*u';
 ci0=inv(c0);
 p=0;
 i=1;
 while (i<=h)
    ci=u*shiftr(u,i,0)'/t;
    p=p+(1/(t-i))*sum(xdiag(ci'*ci0*ci*ci0));
    i=i+1;
 endo;
 p=p*(t^2);
d=createdisplay(1,1)
pv=cdfc(p,df)
str=" Multivariate Portmanteau statistic" | " "
str=str|("Lag order h"+string("                       %2.0f ",h))
str=str|("Model order p"+string("                     %2.0f ",ord))
str=str|("Degrees of freedom  dim^2(h-p)"+string(" %5.0f ",df))
str=str|("statistic P"+string("                   %5.2f ",p))
str=str|("chi2(P,df)"+string("                    %5.4f ",pv))
str=str|" "| "Reject e.g. if chi2(P,df) > 0.95"
show(d,1,1,str)
if (outp==1)
  str
endif
endp;
