proc(y)=prederr(tree,xmat,ymat,type)
;The program prederr.xpl calls 
;pred.xpl, holmo.xpl, endpoint.xpl.
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartsplitopt, cartcv, leafnum, maketr,  
;             pred, prune, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        prederr
; -----------------------------------------------------------------------
; Description  Given a regression tree and observations 
;              gives the mean predicton error of the regression
;              tree for that data.
; -----------------------------------------------------------------------
; Usage         mssr = prederr (tr, x, y, type)
; Input        
;   Parameter  tr
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               tr.val, tr.vec, tr.mean, tr.ssr, tr.nelem.
;               See cartsplit for the description of tr.
;   Parameter  x
;   Definition  n x p vector: represents n points in the sample space
;               at which the prediction of the regression tree will
;               be calculated.
;   Parameter  y
;   Definition  n x 1 vector: 
;               contains the values of the response variable. 
;  Parameter  type
;  Definition  p x 1 vector: 
;              contains the types of the original regression variables,
;              1 means that the corresponding variable is continuous and
;              0 that it is categorical. This vector should be similar to
;              the vector which was given originally as an input to the
;              cartsplit which produced the regression tree tr. 
; Output       
;   Parameter  mssr
;   Definition real number >0: 
;              mean of the squared residuals, that is,
;              sum of squared differences between predictions and
;              observations, divided by the number of observations n.
; -------------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; tree=cartsplit(x,y,#(0,1))
; tree
; xmat=uniform(5,2)
; xmat
; ymat=uniform(5,1)
; ymat
; mssr=prederr(tree,xmat,ymat,#(0,1))
; mssr
; -----------------------------------------------------------------------
; Result  
; Content of object tr.val.split0
; [1,] 0 
; [2,] 1,2
; Content of object tr.val.split1
; [1,] NaN 
; Content of object tr.val.split2
; [1,] 0 
; Content of object tr.val.split3
; [1,] NaN 
; Content of object tr.val.split4
; [1,] NaN 
; Content of object tr.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object tr.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object tr.ssr
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object tr.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Content of object xmat
; [1,] 0.000000 0.231587 
; [2,] 0.003027 0.429810 
; [3,] 0.124776 0.604880 
; [4,] 0.420721 0.615851 
; [5,] 0.003547 0.262006 
; Content of object ymat
; [1,] 0.749410 
; [2,] 0.997687 
; [3,] 0.248579 
; [4,] 0.437815 
; [5,] 0.791837 
;
; Content of object mssr
; [1,] 0.487495 
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
n=dim(xmat[,1])
summa=0
i=1
while (i<=n)
  ennuste=pred(tree,trans(xmat[i,]),type)
  summa=summa+(ymat[i]-ennuste)^2
i=i+1
endo
y=summa/n
endp
  
