proc(y)=prune(tree,alfa)
;The program prune.xpl calls 
;endpoint.xpl, gform.xpl, init.xpl, leafnum.xpl, 
;maketr.xpl, smsr.xpl, final.xpl, suitind.xpl,
;omaind.xpl.
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartsplitopt, cartcv, leafnum, maketr,  pred,
;              prederr, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        prune
; -----------------------------------------------------------------------
; Description   Prunes a smaller regression tree from a tree which has been 
;               created by the cartsplit procedure.
;               Uses error-complexity criterion. 
; -----------------------------------------------------------------------
; Usage         subcs = prune (cs, alfa)
; Input        
;   Parameter  cs
;   Definition  list of vectors: data structure which represents a binary 
;               tree and is produced by cartsplit procedure, contains vectors 
;               cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;               See cartsplit for the description of cs.
;   Parameter  alfa
;   Definition  real number >= 0: the tree subcs is the subtree
;               of cs which minimizes the error-complexity criterion
;               with the complexity parameter alfa.
; Output       
;   Parameter  subcs
;   Definition similar kind of object than cs, see cartsplit for the
;              description of subcs. The tree subcs is the subtree of cs
;              which minimizes the error-complexity criterion when the
;              complexity parameter is alfa.
; -----------------------------------------------------------------------
; Notes    Pruning is described by Breiman, Friedman, Olshen, and Stone,
;          Classification and Regression Trees, Wadsworth, 1984,
;          pages 63, 284. 
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; cs=cartsplit(x,y,#(0,1))
; cs
; ; let us choose a subtree when alfa=100
; subcs=prune(cs,100)
; subcs
; -----------------------------------------------------------------------
; Result  
; Content of object cs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object cs.val.split1
; [1,] NaN 
; Content of object cs.val.split2
; [1,] 0 
; Content of object cs.val.split3
; [1,] NaN 
; Content of object cs.val.split4
; [1,] NaN 
; Content of object cs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object cs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object cs.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object cs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
;
; Content of object subcs.val.split0
; [1,] 0 
; [2,] 1,2
; Content of object subcs.val.split1
; [1,] NaN 
; Content of object subcs.val.split2
; [1,] NaN 
; Content of object subcs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] NaN 
; Content of object subcs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; Content of object subcs.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; Content of object subcs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000       
; -----------------------------------------------------------------------
; Author       Jussi Klemela", 980323         
; -----------------------------------------------------------------------
if (leafnum(tree,1)==1) y=tree
else
subtr=init(tree)
if ((leafnum(subtr,1)==1) || (alfa==0)) y=subtr
    else 
    curlnum=leafnum(subtr,1)
    curalfa=0
    while ((curlnum > 1) && (curalfa <= alfa))
      tr=subtr
      g=gform(tr)
      tmin=omaind(g)
      curalfa=g[tmin]
      subtr=maketr(tr,tmin)
      curlnum=leafnum(subtr,1)
    endo
    if (curalfa <= alfa) tr=subtr endif
endif endif 
y=tr
endp
