proc(q)=qfbin(n, p, x)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     pdfbin, cdfbin, randbin
; -----------------------------------------------------------------------
; Macro        qfbin
; -----------------------------------------------------------------------
; Description  computes the quantile function for a binomial distribution
; -----------------------------------------------------------------------
; Usage        q = qfbin(n, p, x)
; Input        
;   Parameter  n
;   Definition scalar parameter of the binomial distribution
;   Parameter  p
;   Definition scalar parameter of the binomial distribution 
;   Parameter  x
;   Definition m x 1 vector of quantiles (0<=x<=1)
; Output       
;   Parameter  q
;   Definition m x 1 vector of the quantile function
; -----------------------------------------------------------------------
; Example      library ("stats")
;              qfbin (20, 0.1, uniform(10))
; -----------------------------------------------------------------------
; Result    Contents of q
; [ 1,]        0 
; [ 2,]        0 
; [ 3,]        1 
; [ 4,]        2 
; [ 5,]        0 
; [ 6,]        1 
; [ 7,]        2 
; [ 8,]        2 
; [ 9,]        2 
; [10,]        1        
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 980827
; -----------------------------------------------------------------------
  error (sum(x<0)+sum(x>1), "qfbin: x not in interval [0,1]")
  cprob = cumsum(pdfbin(n,p,0:n))
  q=sum(cprob<x')'
  q=q-(q>n)
endp
