
proc (y)=qua(x)
 
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     cosi epa gau tri trian uni
; -----------------------------------------------------------------
;   Macro       qua
; -----------------------------------------------------------------
;   Description  qua computes the quartic kernel, multivariate
; -----------------------------------------------------------------
;   Usage        y = qua(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = qua(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Wolfgang Haerdle, Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------


 y=prod(0.9375.*(abs(x).<1).*(1-x^2)^2,2)

endp

