proc(z)=randbin(n, p, len)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     pdfbin, cdfbin, qfbin
; -----------------------------------------------------------------------
; Macro        randbin
; -----------------------------------------------------------------------
; Description  computes random numbers based on the binomial distribution
; -----------------------------------------------------------------------
; Usage        z = randbin (n, p, len)
; Input        
;   Parameter  n
;   Definition scalar parameter of the binomial distribution
;   Parameter  p
;   Definition scalar parameter of the binomial distribution
;   Parameter  len
;   Definition scalar number of random numbers
; Output       
;   Parameter  z
;   Definition len x 1 vector of random numbers
; -----------------------------------------------------------------------
; Example      ; loads the library "stats"
;              library ("stats")
;              ; reset random generator
;              randomize(0) 
;              randbin(1, 0.5, 10)
; -----------------------------------------------------------------------
; Result        Contents of z
; [ 1,]        0 
; [ 2,]        0 
; [ 3,]        0 
; [ 4,]        0 
; [ 5,]        0 
; [ 6,]        0 
; [ 7,]        0 
; [ 8,]        1 
; [ 9,]        1 
; [10,]        0  
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 980827
; -----------------------------------------------------------------------
  z = qfbin(n, p, uniform(len))
endp
