proc(rc)=rankcorr(x,opt)
; -----------------------------------------------------------------
; Library        stats
; -----------------------------------------------------------------
;  See_also      corr relation
; -----------------------------------------------------------------
;   Macro        rankcorr
; -----------------------------------------------------------------
;   Description  computes rank correlation coefficients according
;                to Spearman and Kendall. In the case of ties, 
;                corrected versions are comptuted.
; -----------------------------------------------------------------
;   Keywords     rank, correlation
; -----------------------------------------------------------------
;   Reference    Bortz/Lienert/Boehnke (1990)
; -----------------------------------------------------------------
;   Usage        rc = corr (x {,opt})
;   Input
;     Parameter  x  
;     Definition   n x 2 matrix, the data.
;     Parameter opt  
;     Definition   string, either "spearman" or "kendall".
;   Output
;     Parameter  rc  
;     Definition   rank correlation between the columns of x.
; -----------------------------------------------------------------
;   Notes     It is not necessary that the input x are ranks.
;             The macro computes the ranks internally.
; -----------------------------------------------------------------
;   Example   library("stats")
;             randomize (0)
;             x = normal (200, 2)
;             rankcorr (x, "spearman")
;             rankcorr (x, "kendall")
;             x = (1:7)~(7:1)
;             rankcorr (x, "spearman")
;             rankcorr (x, "kendall")
; -----------------------------------------------------------------
;   Result
;             Contents of rc
;             [1,] -0.00040501 
;             Contents of rc
;             [1,] -0.0001005 
;             Contents of rc
;             [1,]       -1 
;             Contents of rc
;             [1,]       -1 
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 990218
; -----------------------------------------------------------------
;
  if (exist(opt)==0)
    opt="spearman"
  endif
;
  switch
    case (opt=="kendall")
      x = sort(x)
      n = rows(x)       ;Anzahl aller Paare
      p=matrix(n)-1
      q=p
;
      i = 0
      while (i<(n-1))
        i=i+1
        p[i]=sum(x[(i+1):n,2]>x[i,2])
        q[i]=sum(x[(i+1):n,2]<x[i,2])
      endo
;
;   !!  correct for ties  !!
;
      {tmp,t1}=discrete(x[,1])
      {tmp,t2}=discrete(x[,2])
      t1=sum(t1^2-t1)/2
      t2=sum(t2^2-t2)/2
;
      div=(n^2-n)/2
      div = sqrt( (div-t1)*(div-t2) )
      rc = (sum(p)-sum(q))/div
      break
;
    default; opt=="spearman"
      x[,1]=rank(x[,1])
      x[,2]=rank(x[,2])
      n=rows(x)
      d=sum((x[,1]-x[,2])^2)
;
;   !!  correct for ties  !!
;
      {tmp,t1}=discrete(x[,1])
      {tmp,t2}=discrete(x[,2])
      t1=sum(t1^3-t1)/12
      t2=sum(t2^3-t2)/12
;
      div=(n^3-n)/12
      rc=( 2*div-t1-t2-d )/( 2*sqrt((div-t1)*(div-t2)) )
      break
   endsw
endp




