proc(r) = rankm(x)
; -----------------------------------------------------------------
;   Library       xplore
; -----------------------------------------------------------------
;   See_also      svd eigsm sum
; -----------------------------------------------------------------
;   Keywords      rank, matrix manipulation, linear algebra
; -----------------------------------------------------------------
;   Macro         rankm
; -----------------------------------------------------------------
;   Description   Computes the rank  r  of a matrix  x. 
; -----------------------------------------------------------------
;   Usage         r = rankm(x)
;   Input
;     Parameter   x
;     Definition     n x d matrix, 
;   Output
;     Parameter   r
;     Definition     integer, the rank of the matrix
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = (1~0~0)|(0~2~0)|(0~0~3)|(0~0~4)
;             rankm(x)
; -----------------------------------------------------------------
;   Result    
;             Contents of r
;             [1,]        3 
; -----------------------------------------------------------------
;   Author    CH, StSp 971027, WH 980514, Marlene Mueller 980519
; -----------------------------------------------------------------
  if (rows(x)<cols(x))
    x=x'
  endif
  y = svd(x)
  r = sum( (y.l).<>0)
endp



