library("glm")
proc(beta,bv,bmu,bw)=reca(y,w,z,su2)
; -----------------------------------------------------------------
;    Library	eiv
; -----------------------------------------------------------------
;    See_also	simex
; -----------------------------------------------------------------
;    Macro	reca
; -----------------------------------------------------------------
;    Description    RECA (REgression CAlibration) is a method in which
;		    replacing the unobserved x by its expected value
;		    E(x|w,z) and then to perform a standard analysis.
; -----------------------------------------------------------------
;    Link	  ../tutorials/eivstart.html Tutorial: EIV in XploRe
; -----------------------------------------------------------------
;    Usage    {beta,bv} = reca(y,w,z,su2)
;    Input
;      Parameter  y
;      Definition   n x 1 matrix, the design variables
;      Parameter  w
;      Definition   n x 1 matrix
;      Parameter  z
;      Definition   n x 1 matrix
;      Parameter  su2
;      Definition   the variance of the measurement error 
;    Output
;      Parameter  beta
;      Definition   vector, the estimate
;      Parameter  bv
;      Definition   matrix, the variance of the estimate
; -----------------------------------------------------------------
;  Example library("xplore")
;	   library("eiv")
;	   n=100
;	   randomize(n)
;	   y=floor(uniform(n)+0.25)
;	   w=uniform(n)^2
;	   z=floor(uniform(n)+0.4)
;	   su2=var(w)/4
;	   res=reca(y,w,z,su2)
;	   res.beta
;	   res.bv
; -----------------------------------------------------------------
;    Result  Contents of beta
;            [1,]  -2.7659
;            [2,]    1.531
;            [3,]  0.96504
;            Contents of bv
;            [1,]  0.49574 -0.68988 -0.24432
;            [2,] -0.68988   1.7197  0.06315
;            [2,] -0.24432  0.06315  0.33938
; -----------------------------------------------------------------
;   Author    Hua Liang,  970828
; -----------------------------------------------------------------
     library("glm")
	   m=mean(w)
	   sw2=var(w)
	   ex=(w.>0).*(m*(su2/sw2)+w*((sw2-su2)/sw2))
	   gest=glmest("bilo",matrix(rows(w))~ex~z,y)
	   beta=gest.b
	   bv=gest.bv
           bmu=gest.mu
           bw=gest.w
           doglm(ex~z,y)
endp
