proc(u)=recode (c, p)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    conting measure contmax pswap agglom 
; -----------------------------------------------------------------------
; Macro       recode 
; -----------------------------------------------------------------------
; Description allocates categories 1,2,...,L to intervalls of 
;             categories. The upper bounds of the intervals have
;             to be specified. It is an useful tool in order to
;             join classes and hence to collaps contingency
;             tabels.   
; -----------------------------------------------------------------------
; Usage       u = recode(c, p) 
; Input
;   Parameter  c
;   Definition l x 1  matrix of upper bounds (cutpoints) of
;                     intervals according to p 
;   Parameter  p
;   Definition n x 1  matrix of categories (positive integers
;                     1,2,...,K) which have to be recoded into a
;                     smaller number of integers 1,2,...,l
;
; Output
;   Parameter  u
;   Definition n x 1  matrix containing the new categories of p
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             p = #(2, 1, 3, 4, 3, 2, 1, 4, 5, 4, 3, 2, 4, 1, 1, 2, 1, 4, 5)
;             c = #(2, 4, 5)
;             recode(p,c)
; -----------------------------------------------------------------------
; Result      Content of object u
;
;             [1,]       46 
;             [2,]       43 
;             [3,]       28 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 94111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  i=1
  r=0
  u=0.*matrix(rows(p))
  n=rows(c)
  while(i.<=n)
    l=r
    r=c[i,1]
    ind=((l.<p) && (p.<=r))
    u=u+i.*ind
    i=i+1
  endo
endp