proc(y) = replace(x,w,b)
; ----------------------------------------------------------------------------
; Library       xplore
; ----------------------------------------------------------------------------
;  See_also     isNaN isNumber [] index
; ----------------------------------------------------------------------------
;   Keywords    array manipulation, matrix manipulation
; -----------------------------------------------------------------
;   Macro       replace
; ----------------------------------------------------------------------------
;   Description  Replaces values by other values.
; ----------------------------------------------------------------------------
;   Usage        y = replace(x,w,b)
;   Input
;     Parameter   x
;     Definition        array, string or numeric.
;     Parameter   w
;     Definition        scalar or vector, the value to be replaced.
;     Parameter   b
;     Definition        scalar, the value to replace.
;   Output
;     Parameter   y
;     Definition        array, numeric, matrix x after all
;                       values w are replaced by b.
; ----------------------------------------------------------------------------
;   Example   library("xplore")
;             x=(1~2)|(NaN~4)
;             replace(x,NaN,3)
; ----------------------------------------------------------------------------
;   Result    Contents of y
;             [1,]        1        2 
;             [2,]        3        4 
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 970702
; ----------------------------------------------------------------------------
  if (cols(w)>1)
    w=w'
  endif
  error(dim(dim(w))!=1,"value to be replaced needs to be scalar or ")
  error(prod(dim(b))!=1,"value to replace needs to be scalar")
;
  d=dim(x)
  x=reshape(x,prod(dim(x)))
  n=rows(x)
  inew=(sum(x==w',2)>0)
  inew=inew.*(n+1) + (inew==0).*(1:n)
  x=x|b
  x=x[inew]
;
  y=reshape(x,d)
endp
    




