proc(r)=rgenss(ord,di,t,tb,te,adj,cri,ownbr,ozr,typ,ytt)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelss 
; -----------------------------------------------------------------
;   Macro        rgenss
; -----------------------------------------------------------------
;   Description  generates the restriction matrix for Subset VAR 
; -----------------------------------------------------------------
;   Usage        r=rgenss(ord,di,t,tb,te,adj,cri,ownbr,ozr,typ,ytt)  
;   Input
;     Parameter   ord  
;     Definition      integer, order of VAR
;     Parameter   di 
;     Definition      integer, dimension of time series
;     Parameter   t  
;     Definition      integer, sample size
;     Parameter   tb 
;     Definition      integer, beginning of sample
;     Parameter   te  
;     Definition      integer, end of sample
;     Parameter   adj 
;     Definition      integer, 0=mean adjusted, 1=not mean adjusted
;     Parameter   cri  
;     Definition      integer, 1=AIC, 2=HQ, 3=SC, 4=none
;     Parameter   ownbr 
;     Definition      matrix, matrix of own restrictions
;     Parameter   ozr  
;     Definition      integer, 0=no own restrictions
;     Parameter   typ 
;     Definition      integer, model type (2=subset VAR)
;     Parameter   ytt
;     Definition      matrix, time series
;   Output
;     Parameter   r
;     Definition       the restriction matrix  
; -----------------------------------------------------------------
;   Author    TP A2, CH 980409
; -----------------------------------------------------------------     
if (ozr==0)
  ownbr=ones(di,ord*di+1); 
endif;
if (cri == 4)
   r=1
   if (ozr==1)
      r=paf(eye(ord*di*di+di),vec(ownbr'))'
   endif
else
    a=0     
    b=0   
    k=1   
    s=di*di*ord+di
    r=zeros(s,s)   
    s=di*ord+1
    while (k<=di)
      v=(ownbr[k,].==1)'
      if (max(sum(v)')>0)
         e=zeros(s,1)+v 
         ra=eye(s)
         rn=paf(ra,v)'
         cra=criterss(rn,k,t,ord,di,tb,te,adj,cri,typ,ytt)
         i=1
         while (i<=s)
            if (ownbr[k,i]==1)
               e[s+1-i,1]=0
               if (max(sum(e)')>0) 
                 rn=paf(ra',e)' 
               else
                 rn=0
               endif
               crn=criterss(rn,k,t,ord,di,tb,te,adj,cri,typ,ytt)
               if (crn .> cra)
                 e[s+1-i,1]=1
               else
                 cra=crn
               endif;
            endif;
            i=i+1;
         endo;
         rn=paf(ra',e)';  
         a=b+1;   
         b=b+cols(rn);
         r[(k-1)*s+1:k*s,a:b]=rn;
      endif;
      k=k+1;
   endo;
   if (b<>0)
     r=r[,1:b]; 
   else; 
     r=0; 
   endif;
endif;
endp;
