proc(out)=rot2mat(in, d)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     plotgt orthonormal mat2rot
; -----------------------------------------------------------------------
; Macro        rot2mat
; -----------------------------------------------------------------------
; Description  Computes an orthonormal matrix from a set of Givens
;              rotations.
; -----------------------------------------------------------------------
; Usage        out = rot2mat (in {, d})
; Input
;   Parameter  in
;   Definition p x (p-1)/2 vector
;   Parameter  d
;   Definition p x 1 vector
; Output
;   Parameter  out
;   Definition p x p matrix
; -----------------------------------------------------------------------
; Note         The input matrix is composed by R_1,2 ... R_p-1,p I_d
;              with I_d a diagonal matrix containing one and minus ones.
;              The diagonal matrix I_d is generated by the vector d. If
;              d is not given then I_d will the unit matrix.
; -----------------------------------------------------------------------
; Example      ; loads the library math
;              library ("math")
;              randomize(0)
;              ; loads the library xplore
;              library("xplore")
;              ; generate some orthonormal matrix
;              x = normal(6,6)
;              ; orthonormalize x 
;              o = orthonormal(x)
;              ; compute givensrot
;              {out, d} = mat2rot(o)
;              rot = rot2mat(out, d)
;              ; check it
;              d.*rot-o
; -----------------------------------------------------------------------
; Result       gives the null matrix 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971110
; -----------------------------------------------------------------------
    p   = floor(0.5+sqrt(0.5+2*rows(in)))
    if (exist("d")==1)
      out = diag(d)
    else
      out = diag(matrix(p))
    endif
    i = 0
    k = 0
    while (i<p)
      i = i+1
      j = i
      while (j<p)
        j  = j+1
        k  = k+1
        r  = (1:p)'==(1:p)
        r[i,i] = cos(in[k])
        r[i,j] = -sin(in[k])
        r[j,i] = sin(in[k])
        r[j,j] = cos(in[k])
        out    = out*r
      endo
    endo
endp