proc (v, wo, s) = runnew(disp, w, u, m, x, y, t, errfun, dec, res, fs, weidist, vmeth)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        runnew 
; -----------------------------------------------------------------------
; Description  optimize a neural network by a quadratic approximation 
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  {xt, yt, xe, ye, we, s, yep, ybp, v, ve} = runinit(x, y, t, errfun, w, u, dec, m,vmeth)             
  i = 1               
  k = 1               
  d = 0.5
  wo = w            
  wb = wo            
  wt = wo               
  while (d.>0.001)               
    wt[k,3] = wb[k,3] + d               
    yb = nnfunc (wt, u, xt)             
    sp = _errfun(yt, yb, wt[,3], dec)               
    wt[k,3] = wb[k,3] - d               
    yb = nnfunc (wt, u, xt)               
    sm = _errfun(yt, yb, wt[,3], dec)               
    b  = 0.5.*(sp-sm)./d               
    a  = (sp+sm-2.*s[1,1])./(2.*d^2)               
    if (a.<=0)               
      if (sp.<sm)               
        wb[k,3] = wb[k,3] + d               
        s[1,1] = sp               
        {wo, s, v, we, ybp, yep, ve}=runshow(disp, wb, u, s, m, v, ybp, yep, xt, xe, we, dec, ve, i, ye, res, weidist, errfun, vmeth)         
      else               
        wb[k,3] = wb[k,3] - d               
        s[1,1] = sm               
        {wo, s, v, we, ybp, yep, ve}=runshow(disp, wb, u, s, m, v, ybp, yep, xt, xe, we, dec, ve, i, ye, res, weidist, errfun, vmeth)         
      endif               
    else               
      wt[k,3] = wb[k,3] - 0.5.*b./a               
      yn = nnfunc(wt, u, xt)               
      sn = _errfun(yt, yn, wt[,3], dec)               
      if (sn.<s[2,2])               
        wb[k,3] = wt[k,3]               
        s[1,1] = sn               
        {wo, s, v, we, ybp, yep, ve}=runshow(disp, wb, u, s, m, v, ybp, yep, xt, xe, we, dec, ve, i, ye, res, weidist, errfun, vmeth)         
      else               
        k = k+1               
        if (k.>rows(wo))               
          k = 1               
          d = d./2               
        endif               
      endif               
    endif               
    i = i+1               
  endo               
  wo = wb~we[,3]               
  s = s[,2]               
  if (fs)            
    finalshow (disp, wo, u, s, ybp, yep, xt, xe, dec, v, ve, m, weidist, vmeth)               
  endif               
endp               
