proc(y)=sfvonmw(coeff,covu,di,ord,t)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      coeffest
; -----------------------------------------------------------------
;   Macro         sfvonmw
; -----------------------------------------------------------------
;   Description   standard errors for mean in VAR models
; -----------------------------------------------------------------
;   Usage         y = sfvonmw(coeff,covu,di,ord,t)
;   Input
;     Parameter   coeff 
;     Definition    matrix, estimated coefficients
;     Parameter   covu 
;     Definition    matrix, covariance
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   t 
;     Definition    integer, number of observation time points
;   Output
;     Parameter   y
;     Definition     matrix of standard errors for mean 
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971212
; -----------------------------------------------------------------
  eyedi=eye(di)
if (ord == 0)
   cov=eyedi
else
   cov=inv(eyedi-coeff*(kron(ones(ord,1),eyedi)))
endif
sf=diag(cov*covu*cov')/t
y=sf^.5
endp
