proc(y)=simvar(u,y0,a)
; -----------------------------------------------------------------
;   Library      multi   
; -----------------------------------------------------------------
;   Macro        simvar
; -----------------------------------------------------------------
;   Description  computes a multidimensional autoregressive
;                time series.
; -----------------------------------------------------------------
;   Usage        y = simvar(u,y0,a)     
;   Input
;     Parameter    u      
;     Definition   (K x T)-matrix of 'noise'. Each column represents
;                  the K-dimensional noise, or innovation of a point in time.       
;     Parameter    y0 
;     Definition   (K x p)-matrix of starting ('pre-sample')-values of 
;                  time series.
;     Parameter    a   
;     Definition   (K x K*p) or (K x K*p+1)-matrix of model parameters.
;                  The model can be specified with [(K x K*p+1)] or without
;                  [(K x K*p)] intercept. If an intercept is specified simvar()
;                  regards the first column of 'a' as the intercept.
;   Output                                                           
;     Parameter     y    
;     Definition    (K x p+T)-matrix of autoregressive time series. The first
;                   p columns of 'y' are 'y0', the remaining are the computed
;                   time series.
; -----------------------------------------------------------------
;   Example        library("multi")
;                  a = #(.4,0)~#(.2,-.1)
;                  randomize(101)
;                  u = normal(2,5)
;                  simvar( u, 10|20, a)  
; -----------------------------------------------------------------
;   Result         Contents of y
;                  [1,]       10    8.995   2.8483   1.8941  0.28264   1.2074 
;                  [2,]       20  -3.2578   1.6874  -1.6002   1.7628 -0.70274 
; -----------------------------------------------------------------
;   Author Benkwitz, 98.01.27 
; -----------------------------------------------------------------
  K = rows(y0)
  p = cols(y0)
  switch
    case (cols(a)==(K*p))     ; case: no intercept
      xi=vec(rev(y0')')
      kp=rows(xi)-rows(u)
      y=zeros(rows(u),cols(u))
      i=1
      while (i<=cols(u))
        yi = a*xi+u[,i]
        y[,i]=yi
        if (kp)
          xi=yi|xi[1:kp]
        else
          xi=yi
        endif
        i=i+1
      endo
      y=y0~y
      break
    case (cols(a)==(K*p+1))  ; case: intercept (first column)
      xi=vec(rev(y0')')
      kp=rows(xi)-rows(u)
      y=zeros(rows(u),cols(u))
      i=1
      while (i<=cols(u))
        yi = a*(1|xi)+u[,i]
        y[,i]=yi
        if (kp)
          xi=yi|xi[1:kp]
        else
          xi=yi
        endif
        i=i+1
      endo
      y=y0~y
      break
    default
      error(1, "Couldn't execute simvar() [bad input].")
  endsw
endp
