proc (z) = stack (x, y)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      | ~ reshape reduce
; -----------------------------------------------------------------
;   Keywords     array manipulation
; -----------------------------------------------------------------
;   Macro        stack
; -----------------------------------------------------------------
;   Description  Joins two arrays along the third dimension.
; -----------------------------------------------------------------
;   Usage        z = stack (x, y)
;   Input
;     Parameter  x  
;     Definition d1 x d2 x p array
;     Parameter  y
;     Definition d1 x d2 x q array
;   Output
;     Parameter  z
;     Definition stack of x and y
; -----------------------------------------------------------------
;   Notes        The dimension of x and y must be the same except
;                the third one and must not be larger than three.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = reshape (1:8, #(2,4))
;             y = matrix (2, 4)
;             stack (x, y)
; -----------------------------------------------------------------
;   Result 
;             Contents of z   
;	      [,,1,1,1,1,1,1]
;	      [1,]     1     3     5     7 
;	      [2,]     2     4     6     8 
;	      [,,2,1,1,1,1,1]
;	      [1,]     1     1     1     1 
;	      [2,]     1     1     1     1 
; -----------------------------------------------------------------
;   Author    TTK, 960424
; -----------------------------------------------------------------
  dx = dim(x)
  dy = dim(y)

  error (dim(dx)>3 || dim(dy)>3, "cannot handle more than 3 dims")

  if (dim(dx) < 3)  
    dx = dx | matrix(3-dim(dx))
  endif
  if (dim(dy) < 3)  
    dy = dy | matrix(3-dim(dy))
  endif
  d = abs(dx-dy)[#(1:2)]
  error (d != 0, "rows and/or cols don't match")
  rs = dx
  rs[3] = dx[3]+dy[3]
  z = reshape(#(x,y), rs)
endp

