proc(data)=standard(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istatransformation
; -----------------------------------------------------------------------
; Macro        standard
; -----------------------------------------------------------------------
; Description  standardizes the  selected variables in ISTA. The 
;              transformed variables can replace
;              the original ones or can be appended on the end of data.x.
;              the type is automatically set continuous.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data    = datain
  datah   = datain
  datah1   = paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
  ind=paf(1:rows(data), data.rowcase&&data.randcase&&data.rowmissing)
  stringh = data.colname
  colth   = data.coltype
  colvh   = data.colvar  
  colmh   = data.colmissing
  text="((x-mean(x)/sqrt(var((x)))"
  sel=choosevariable2(data,text)
  i = 0
  while (i.<rows(sel))
    i = i+1
    if(sel[i])selhead2="Create a new variable?"
      selitem2="Yes"|"No"
      sel2=selectitem(selhead2,selitem2,"single")
      if(sel2[2])  
        xneu=NaN*matrix(rows(data))
        xneu[ind]=(datah1[,i]-mean(datah1[,i]))/(sqrt(var((datah1[,i]))))
        datah[,i]=xneu
      endif
      if(sel2[1]) 
        xneu=NaN*matrix(rows(data))
        xneu[ind]=(datah1[,i]-mean(datah1[,i]))/(sqrt(var((datah1[,i]))))
        datah=datah~xneu
        stringh1=string("X%.0f", cols(datah)) 
        stringh=stringh|readvalue("New variablename:", stringh1)
        colth=colth|0 ;new variable continuous
        colvh=colvh|1 ;new variable not deleted
        colmh=colmh|1 ;new variable not deleted 
      endif
    endif
  endo
  data.x=datah
  data.colname=stringh
  data.coltype=colth
  data.colvar=colvh
  data.colmissing=colmh
endp