proc(d)=station(forec,phi,icovu,covh,di,ord,te,t,h,ytt,outp)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      strucbru
; -----------------------------------------------------------------
;   Macro         station
; -----------------------------------------------------------------
;   Description   test for structural change (for VAR models)
; -----------------------------------------------------------------
;   Usage         d=station(forec,phi,icovu,covh,di,ord,te,t,h,ytt,outp)
;   Input
;     Parameter   forec 
;     Definition    matrix
;     Parameter   phi 
;     Definition    matrix
;     Parameter   icovu 
;     Definition    matrix
;     Parameter   covh 
;     Definition    matrix
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   t 
;     Definition    integer, number of observation time points
;     Parameter   h 
;     Definition    integer, forecast horizon
;     Parameter   ytt
;     Definition    vector, the transformed time series
;     Parameter   outp
;     Definition    matrix
;   Output
;     Parameter   d
;     Definition     matrix
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971212
; -----------------------------------------------------------------
uh=vec(ytt[,te+1:te+h]) - forec
uh2=uh[vec(rev(reshape(aseq(di*h,di*h,(-1)),di|h))),]
tau=0
lam=0
i=1
while (i<=h)
   ehh=phi[,1:(i*di)]*uh2[((di*h)-(i*di)+1):(di*h),]
   tau=tau | ehh'*inv(covh[(i-1)*di+1:i*di,])*ehh
   lam=lam|lam[i,]*(i-1)/i+ uh[(i-1)*di+1:di*i,]'* icovu * uh[(i-1)*di+1:di*i,]/i;
   i=i+1;
endo;
tau=tau[2:h+1,]/di;
lam=lam[2:h+1,]*t/(t+di*ord+1) /di;
flam=cdff(lam,aseq(di,h,di),ones(h,1)*t-di*ord-1);
ftau=cdff(tau,di,t-di*ord-1);
mat=string(" %2.0f    ",aseq(1,h,1))
mat=mat+string(" %5.3f ",tau)
mat=mat+string("       %5.3f ",ftau)
mat=mat+string("       %5.3f ",lam)
mat=mat+string("       %5.3f ",flam)
head="     TESTS FOR STRUCTURAL CHANGE "
head= head|" " |"  h       t1          F(t1)          t2         F(t2) "
mat=head| " " | mat
d=createdisplay(2,1)
show(d,1,1,mat)
if (outp==1)
  mat
endif
str= " Reject stability hypothesis e. g. if F(ti) > 0.95 ! "
str=str|" "| " h:     forecast horizon "
str=str|" "| " t1:    test statistic based on one forecast period "
str=str|" "| " F(t1): cdf of F with dim and (T-dim*p-1) df at t1"
str=str|" "| " t2:    test statistic based on several forecast period "
str=str|" "| " F(t2): cdf of F with h*dim and (T-dim*p-1) df at t2"
show(d,2,1,str)
if (outp==1)
  str
endif
endp;
