proc(d)=stocksim()
; -----------------------------------------------------------------
; Library         finance
; -----------------------------------------------------------------
;  See_also       stockest, stockestsim
; -----------------------------------------------------------------
;   Macro         stocksim
; -----------------------------------------------------------------
;   Description   stocksim is simulating random processes for a
;                 stock price by three different ways:
;                 using a Wiener Process,
;                 using a compounded Poisson Jump Process with a 
;		  log normal distribution of jump height     and
;                 using a mixture of both
; -----------------------------------------------------------------
;   Usage         stocksim()
; -----------------------------------------------------------------
;   Example   library("finance")
;             stocksim()
; -----------------------------------------------------------------
;   Result    a display plotting the three random processes
; -----------------------------------------------------------------
;   Author    Hrdle, Kleinow 990510
; -----------------------------------------------------------------
 // **** init valuenames for readvalue
 valuenames="starting value of underlying asset"|"increasing rate of return"
 valuenames=valuenames|"volatility (sigma)"|"days to expiration"
 valuenames=valuenames|"shocks per day"|"expected number of jumps"
 valuenames=valuenames|"volatility for the height of jump"
 // **** init default values for readvalue
   defaults=#(200,5.0,10.0,200,2,20,.5)  ;(s0,mue,sigma,dte,dt,lambda,spr)
 // **** init strings and defaults for selectitem
 sel = 0|0
 selhead = "Do you want to exit from stocksim ?"
 selitem = "Yes"|"No"
 // **** start
 while (sel[1]==0)  
   values=readvalue(valuenames,defaults)
   // **** check for bad values
   error (values[1] < 0      , "stocksim: "+valuenames[1]+" can not be smaller than 0")
   error (values[2] < 0      , "stocksim: "+valuenames[2]+" has to be >= 0")
   error (values[3] < 0      , "stocksim: "+valuenames[3]+" has to be >= 0")
   error (values[4] <= 0     , "stocksim: "+valuenames[4]+" has to be > 0")
   error (values[5] <= 0     , "stocksim: "+valuenames[5]+" has to be > 0")
   error (values[6] < 0      , "stocksim: "+valuenames[6]+" has to be >= 0")
   error (values[7] < 0      , "stocksim: "+valuenames[7]+" has to be >= 0")
   // **** calculation
   values[5]=1/values[5]
   values[2]=log(values[2]/100+1)/365
   values[3]=log(values[3]/100+1)/sqrt(365)
   values[7]=log(values[7]/100+1)
   n=values[4]/values[5]                ; length of series
   dw=normal(n)                                 ; increment of BM
   // **** alloc matrices
   s=matrix(n)
   sss=matrix(n)
   ss=matrix(n)
   // **** seting initial value
   s[1]=values[1]
   sss[1]=values[1]
   ss[1]=values[1]
   ds=dw*values[3]*sqrt(values[5])      ; increment of sigma * BM
   i=1
   while (i<n)
     i=i+1
     direct = (2*(uniform(1)<.5)-1)   ; s = -1 <==> decrease, ...
     jump = (uniform(1) <= (values[6]/n)) * direct * exp(normal(1)) ; jump size
     jump=values[7]*jump
     s[i]=s[i-1]*exp(values[2]*values[5]+ds[i]+jump)      ; mixed process
     sss[i]=sss[i-1]*exp(values[2]*values[5]+ds[i])       ; diffusion
     ss[i]=ss[i-1]*exp(jump)                              ; jump process
   endo
   t=values[5]*(0:(n-1))                ; time vector
   s  =t~s
   sss=t~sss
   ss =t~ss
   setmaskp(s,0,1,1)
   setmaskp(sss,0,1,1)
   setmaskp(ss,0,1,1)
   line=(1:(n-1))~(2:n)
   setmaskl(sss,line',0,1,1)
   setmaskl(ss,line',2,1,1)
   setmaskl(s,line',1,1,1)
   d=createdisplay(1,1)
   show(d,1,1,s,sss,ss)
   setheadline(d,1,1,"jump process, diffusion and mixture")
   setgopt(d,1,1,"xlabel", "time")
   setgopt(d,1,1,"ylabel", "stock price")
   sel = selectitem(selhead, selitem,"single")
 endo
endp
