proc(ix)=symroot(x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      inv, svd, ginv
; -----------------------------------------------------------------
;   Macro        symroot
; -----------------------------------------------------------------
;   Description  Calculates the symmetric root 
;                     of a symmetric positive semidefinite matrix,(s.p.s.d.) ie.
;                     symroot(x)=symroot(x)' and symroot(x)*symroot(x) = x.
;                     uesful for simulation of multivariate normal variates 
;                     with a given Covariance Structure
; -----------------------------------------------------------------
;   Keywords     inverse, generalized inverse, pseudo inverse, 
;                matrix manipulation , symmetric root of p.s.d. matrix
; -----------------------------------------------------------------
;   Usage         ix = symroot(x)    
;   Input
;     Parameter   x  
;     Definition      p x p matrix , s. p.s.d.
;   Output                                                           
;     Parameter   ix
;     Definition      p x p matrix , the symmtric root of x
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("plot")
;             C=#(2,1)~#(1,1)
;             x   = normal(2,300)
;             x   =(symroot(C)*x)'
;            setmaskp(x, 4, 3, 8) 
;            disp = createdisplay(1,1)
;            show(disp,1,1,x)
; -----------------------------------------------------------------
;   Result    generates a sample of size #300 of N_2(0,C) 
;                   and plots it 
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991020
; -----------------------------------------------------------------
  error((x<>x'), "Matrix x not symmetric")
  y   = svd(x)
  error(sum(y.l<0)>0, "Matrix x not positive semidefinite")
  ix = y.u*(sqrt(y.l).*y.u')        
endp
