; -----------------------------------------------------------------
; Library        cafpe 
; -----------------------------------------------------------------
;  See_also		grid
; -----------------------------------------------------------------
;   Macro        makegrid
; -----------------------------------------------------------------
;   Keywords    graphics
; -----------------------------------------------------------------
;   Description Quantlet for generating a two-dimensional grid
; -----------------------------------------------------------------
;   Usage   xgrid = makegrid(xanf,xstep,xnum)
;   Input
;     Parameter   xanf
;     Definition  scalar, beginning of grid
;     Parameter   xstep
;     Definition  scalar, step size
;     Parameter   xnum
;     Definition  scalar, number of grid points
;   Output
;     Parameter   xgrid
;     Definition  (xnum^2 x 2) matrix of grid points
; -----------------------------------------------------------------
;   Example     pathcafpe = "tp/cafpe/"
;               func(pathcafpe + "makegrid.xpl")
;		    xanf    = 1
;               xstep   = 0.1
;               xnum    = 5
;               xgrid   = makegrid(xanf,xstep,xnum)
;               "xgrid" xgrid
; -----------------------------------------------------------------
;   Result    grid points for example to compute the
;             plot of a two-dimensional (auto)-regression function
; -----------------------------------------------------------------
;   Author    Tschernig  000420
; -----------------------------------------------------------------

proc (xgrid) = makegrid(xanf,xstep,xnum);

x1  = aseq(xanf,xnum,xstep);
i = 1;
j = 1;
xgrid   = zeros(xnum^2,2);
do

    xgrid[i:i+xnum-1,] = (x1[j] * matrix(xnum,1))~x1;
    i = i + xnum;
    j = j + 1;
until (i > xnum^2);

endp;
