; -----------------------------------------------------------------
; Library        cafpe
; -----------------------------------------------------------------
;  See_also      tp/cafpe/xorigex
; -----------------------------------------------------------------
;   Macro        xorigst
; -----------------------------------------------------------------
;   Keywords    time series analysis
; -----------------------------------------------------------------
;   Description  Quantlet to cut off starting values from
;                matrices of dependent and independent variables
;                for time series analysis. This is needed if one
;                always wants to cut off the same number of observations
;                when analysing AR(p) models with different orders.
; -----------------------------------------------------------------
;   Usage   { xnew,ynew } = xorigst(xorig,yorig,xraw,lagmax)
;   Input
;     Parameter   xorig
;     Definition  (nn x p) matrix of lags
;     Parameter   yorig
;     Definition  (nn x 1) matrix of dependent variable
;     Parameter   xraw
;     Definition  (n x 1)  vector of time series
;     Parameter   lagmax
;     Definition  scalar, largest lag for consideration (for which
;                   starting values have to be cut off)
;   Output
;     Parameter   xnew
;     Definition  ((n-lagmax) x p) matrix of lags
;     Parameter   ynew
;     Definition  ((n-lagmax x 1) vector of  matrix  of dependent variable
; -----------------------------------------------------------------
;   Example     pathcafpe = "tp/cafpe/"
;	    	    func(pathcafpe + "xorigex.xpl")
;               func(pathcafpe + "xorigst.xpl")
;               xraw    = #(1:100)
;               lags    = 1|10
;               lagmax  = 15
;               { xorigau,yorig }= xorigex(xraw,0,lags,"no")
;               { xnew,ynew } = xorigst(xorigau[1:rows(yorig),],yorig,xraw,lagmax)
;               "xnew~ynew" 
;               xnew~ynew
; -----------------------------------------------------------------
;   Result    Matrix of dependent variable ynew with lagmax observations
;             cut off such that AR(p) models can be fitted up to
;             p=lagmax.
;             The matrix of lagged variables xnew is adjusted accordingly.
; -----------------------------------------------------------------
;   Author    Tschernig  000420 
; -----------------------------------------------------------------

proc (xnew,ynew) = xorigst(xorig,yorig,xraw,lagmax);

xrawrows   = rows(xraw);
yorigrows  = rows(yorig);

ynew        = yorig[lagmax-(xrawrows-yorigrows)+1:yorigrows,1];
xnew        = xorig[lagmax-(xrawrows-yorigrows)+1:yorigrows,];

endp

/* ========================================================================== */
