proc()=tw1d(x)
; ---------------------------------------------------------------------
; Library     tware
; ---------------------------------------------------------------------
; See_also    twrandomsample twpvalue twnormalize twpearson twclt twlinreg
; ---------------------------------------------------------------------
; Macro       tw1d
; ---------------------------------------------------------------------
; Description teachware quantlet tw1d shows a histogram of user defined
;							data and offers interactive visual analysis of this data by means of 		 
;							box plots (for mean and median) and QQ-plots. Transformations 
;							may be applied to the data in order to study the change
;							in distribution and box plots.
; ---------------------------------------------------------------------
; Usage       tw1d({x})
; Input           
; Parameter  	x  
; Definition  vector (n x 1) with user defined data
; ---------------------------------------------------------------------
; Notes      the "mean box plot" contains +/- one and two STD   
; ---------------------------------------------------------------------
; Example      ; load teachware library
;            library("tware")
;            ; predefine asymmetric data
;            x = exp(normal(100))
;            ; call tw1d teachware quantlet
;            tw1d(x)
; ---------------------------------------------------------------------
; Result    a two part window with the histogram of the actual data
;						distribution in the upper port and a jittered dot plot of the data 
;						in the lower part. The histogram and the dot plot changes with 
;						the chosen transformations.
; ---------------------------------------------------------------------
; Keywords    teachware
; ---------------------------------------------------------------------
; Reference  Hrdle, W., Klinke, S. and Marron, J.S. (1999) Connected
;						teaching of statistics 
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      SK, WH, 990103
; ---------------------------------------------------------------------
	if (exist(x)<>1)				// check for optional input 
    x = normal(100)^2
  endif
  selhead = "Choose" 
  dmode   = 0
  selitem = "Mean "|"Median "|"Mean boxplot "|"Median boxplot "|"Normal distribution "|"Extra Q-Q-Plot "|"Square root"|"Logarithmic"|"No transformation"
  i1      = 1:6
  i2      = 7:9
  status  = 0.*matrix(rows(i1|i2))
  status[rows(status)] = 1 
  d = createdisplay(1,1)			// generate main display
  qqd = 0 								// set QQ plot display to nil
  do
    xt = x
    if (status[i2[1]])				// SQRT trafo clicked
      error (min(x)<=0, "data must be positive for SQRT transformation")
      xt = sqrt(x)
      title = "Sqrt(x)"
    endif
    if (status[i2[2]])				// LOG trafo clicked
      error (min(x)<=0, "data must be positive for LOG transformation")
      xt = log(x)
      title = "Log(x)"
    endif
    if (status[i2[3]])				// no trafo wanted
      xt = x
      title = "x"
    endif
// *********************************************** start plotting
    hist = grhist(xt, (max(xt)-min(xt))/30)	// create histo graphics object
    dot  = grdot(xt)				// create dotplot graphics object
    dot  = grscale(dot, 1|(-max(hist[,2])/5))
    dot  = grmove(dot, 0|(-max(hist[,2])/20))
    plist = list (hist, dot)			// make list of hist and dot graphic
    if (status[1])				// append line for mean value
      ll = grxline(mean(xt), dot[,2], 1)
      append (plist, ll)
    endif
    if (status[2])				// append line for median value
      rl = grxline(quantile(xt, 0.5), dot[,2], 4)
      append (plist, rl)
    endif
    if (status[3])
      lb = grboxmean(xt, 1)
      lb = grscale(lb, 1|(-0.8*max(hist[,2])/5))
      lb = grmove(lb, 0|(-0.25*max(hist[,2])/5))
      append (plist, lb)
    endif
    if (status[4])
      rb = grboxmedian(xt, 4)
      rb = grscale(rb, 1|(-0.8*max(hist[,2])/5))
      rb = grmove(rb, 0|(-0.45*max(hist[,2])/5))
      append (plist, rb)
    endif
    if (status[5])
      t  = aseq (min(xt), 100, (max(xt)-min(xt))/99)
      pf = t~exp(-(t-mean(xt))^2/var(xt))/sqrt(2*pi*var(xt))
      setmaskp(pf, 0, 0, 0)
      setmaskl(pf, (1:rows(t))', 2,1,3)
      append (plist, pf)
    endif
    if (status[6])
      qqd = createdisplay(1,1)
      show (qqd, 1, 1, grqqn(xt))
      setgopt(qqd,1,1,"title", title)
    else
      qqd = 0
    endif
    switch
    case (size(plist)==2)
      show(d,1,1,plist{1},plist{2})
      break;
    case (size(plist)==3)
      show(d,1,1,plist{1},plist{2},plist{3})
      break;
    case (size(plist)==4)
      show(d,1,1,plist{1},plist{2},plist{3},plist{4})
      break;
    case (size(plist)==5)
      show(d,1,1,plist{1},plist{2},plist{3},plist{4},plist{5})
      break;
    case (size(plist)==6)
      show(d,1,1,plist{1},plist{2},plist{3},plist{4},plist{5},plist{6})
      break;
    case (size(plist)==7)
      show(d,1,1,plist{1},plist{2},plist{3},plist{4},plist{5},plist{6},plist{7})
      break
    endsw
    setgopt(d,1,1,"title", title)
    seli = selitem
    if (sum(status[i1]==0))
      ind  = paf(i1, status[i1]==0)
      seli[ind] = seli[ind]+"(add)"
    endif
    if (sum(status[i1]==1))
      ind  = paf(i1, status[i1]==1)
      seli[ind] = seli[ind]+"(delete)"
    endif
    do
      sel = selectitem (selhead, seli)
    until (sum(sel[i2])<2)
    status[i1] = (sel[i1] || status[i1])-(sel[i1] && status[i1])
    if (sum(sel[i2]))
      status[i2]=sel[i2]
    endif      
  until (sum(sel)==0)
endp

