proc(uselret)=twles4(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles2 twles3 twles5 twles6 twles7 twles8
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles4
; -----------------------------------------------------------------------
; Description  Shows the approximation of a sine function which changes
;              its frequency. 
;              You can choose between different wavelet base, different 
;              number of father wavelet coefficients and different views 
;              to the mother wavelet coefficients.
; -----------------------------------------------------------------------
; Usage        twles4()
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (ds, ds)
  d4 = createdisplay(2,1)
  n  = 128
  {tmp, x} = chfunc (usel, 0, n, #(0,0,0,1))
  h = getglobal ("daubechies4")
  l = 4
  v = 1
  {a, b} = fwt (x, l, h)
  selhead = "Wavelet lesson 4"
  selitem = "Change basis"|"Change level"|"Change view"|"Print"
  end = 0
  do
    if (v.=1)
      waveint1b (d4, 1, a, b, x, 1)
    endif
    if (v.=2)
      waveint3b (d4, 1, a, b, x, 1)
    endif
    if (v.=3)
      waveint2b (d4, 1, a, b, x, 1, b)
    endif
    if (v.=4)
      waveint4b (d4, 1, a, b, x, 1, l, h)
    endif
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:4))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    sel = selectitem (selhead, selitem)
    end = sum(sel).=0
    if (sel[1])
      h = chbase (h)
      {a, b} = fwt (x, l, h)
    endif
    if (sel[2])
      ru = rows(usel)
      if (ru.>1)
        l    = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          l = readvalue ("Change level", l)
        until ((l>3) && (l<rows(x)))
      endif
      l = 2^floor(log(l)./log(2))
      {a, b} = fwt (x, l, h) 
    endif  
    if (sel[3])
      {usel, v} =chview(usel, v)
    endif
    if (sel[4])
      usel = twprint(d4, usel)
    endif
  until (end)
  uselret = usel
endp
