proc()=twnormalize(nin)
; -----------------------------------------------------------------------
; Library      tware
; -----------------------------------------------------------------------
; See_also     twrandomsample twpvalue twclt twpearson tw1d twlinreg 
; -----------------------------------------------------------------------
; Macro        twnormalize
; -----------------------------------------------------------------------
; Description  teachware quantlet twnormalize shows the distribution of 
;							 binomials B(n1, p), B(n2, p) and B(n3, p) with increasing 
;							 n1, n2, n3. One may shift the distribution by the mean 
;							 value and divide by the standard deviation in order to study
;							 the normalizing effect. In addition a normal density may
;							 be graphically overlaid. 
; -----------------------------------------------------------------------
; Usage        twnormalize({nin})
; Input        
;   Parameter  nin
;   Definition default values for input parameters
; -----------------------------------------------------------------------
; Example    ; load teachware library
;            library("tware")
;            ; default value p=0.6 n=10,20,40
;            n=0.7|10|20|40
;            ; call normalize example
;            twnormalize(n)
; -----------------------------------------------------------------------
; Result			a graphical display with six window ports. The 
;							three left windows contain the original B(n, p) distribution
;							the three right windows contain the rescaled and normalized
;							distributions
; -----------------------------------------------------------------------
; Author	SK, WH, 990102
; -----------------------------------------------------------------------
; Keywords   teachware
; -----------------------------------------------------------------------
  if (exist(nin)<>1)
    n=0.7|10|20|40
  else
    n=nin
  endif
  r = rows(n)-1
  i = 0
  scale = 0*matrix(2,2)
  s = 1
  m = 0
  while (i<r)
    i=i+1
    lgr=grbinomial(n[i+1], n[1])		// display the binomial distribution
    s  = min(s|n[i+1]*n[1]*(1-n[1]))
    m  = max(m|n[i+1]*n[1])
    scale[1,1] = min(scale[1,1]|lgr[,1])
    scale[1,2] = min(scale[1,2]|lgr[,2])
    scale[2,1] = max(scale[2,1]|lgr[,1])
    scale[2,2] = max(scale[2,2]|lgr[,2])
  endo
  scale[1,1] = (scale[1,1]-m)/s
  scale[2,1] = scale[2,1]/s
  setmaskp(scale, 0, 0, 0)
  d = createdisplay(r,2)
  selhead = "Choose transformation"
  selitem = "Subtract mean"|"Divide by Stddev"|"Normal distribution"|"Quit"
  sel = 0|0|0
  do
    i = 0
    while (i<r)
      i=i+1
      lgr=grbinomial(n[i+1], n[1])
      m = n[i+1]*n[1]
      s = sqrt(n[i+1]*n[1]*(1-n[1]))
      lgr.data[,2] = 2*s*lgr.data[,2]./sum(lgr.data[,2])
      lstr = string("B(%.0f,%.1f)", n[i+1], n[1]) 
      rgr=lgr
      rstr=lstr
      if (sel[1])
        rgr.data[,1] = rgr.data[,1]-m
        rstr= "(" + rstr + string ("-%.2f)" , m)
      endif
      if (sel[2]) 
        rgr.data[,1] = rgr.data[,1]/s
        rstr=rstr+string("/%.2f", s)
      endif
      show(d, i, 1, lgr, scale)
      setgopt(d, i, 1, "title", lstr) 
      if (sel[3])
        dn = aseq(min(rgr.data[,1]), 100, (max(rgr.data[,1])-min(rgr.data[,1]))/99)
        dn = dn~pdfn(dn)
        setmaskp(dn, 0, 0, 0)
        setmaskl(dn, (1:rows(dn))', 4, 1, 3)
        show(d, i, 2, rgr, dn, scale) 
      else
        show(d, i, 2, rgr, scale)
      endif
      setgopt(d, i, 2, "title", rstr) 
    endo
    sel = selectitem(selhead, selitem)
  until (sel[4])
endp