proc()=twpvalue(n)
; -----------------------------------------------------------------------
; Library      tware
; -----------------------------------------------------------------------
; See_also     twrandomsample twclt twnormalize twpearson twlinreg tw1d
; -----------------------------------------------------------------------
; Macro        twpvalue
; -----------------------------------------------------------------------
; Description  teachware quantlet twpvalue computes the p-value
;              of a B(n, p) distribution
; -----------------------------------------------------------------------
; Usage        twpvalue({nin})
; Input        
;   Parameter  nin 
;   Definition vector (3 x 1) with n, p and observed counts
; -----------------------------------------------------------------------
; Example    ; load teachware library
;            library("tware")
;            ; predefine counts for n, p and observed counts
;            n=6|0.5|5
;            ; call p value teachware quantlet
;            twpvalue(n)
; -----------------------------------------------------------------------
; Result     a graphical display with the barchart in the upper port
;            and text in the lower port.   
; -----------------------------------------------------------------------
; Author	SK, WH, 981230
; -----------------------------------------------------------------------
; Keywords   teachware
; -----------------------------------------------------------------------
  if (exist(n)<>1)
    n=6|0.5|5
  endif
  n=readvalue("number of trials"|"prob of success"|"observed value", n)
  str = string("P(X>=%.0f)", n[3])|string("P(X=%.0f)", n[3])
  s   = selectitem("Choose:", str)
  switch 								// ask for p-value type
  case (s[1]==1)
    ind = ((0:n[1])<n[3])
    val = sum(pdfbin(n[1],n[2],0:n[1]).*(1-ind))
    str = str[1]+string("=%.4f", val)
    break
  case (s[2]==1)
    ind = ((0:n[1])<>n[3])
    val = sum(pdfbin(n[1],n[2],0:n[1]).*(1-ind))
    str = str[2]+string(" = %.4f", val)
    break
  default
    ind = 0
    str = " "
  endsw
  col = 4*ind
  twdex2 = createdisplay(2,1)
  grbin = grbinomial(n[1], n[2], col)	// display the binomial with colored area
  str = string("B(%.0f,%.1f) with black is ", n[1], n[2]) + str 
  show (twdex2, 1, 1, grbin)
  show (twdex2, 2, 1, str)
endp

